package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import org.slf4j.Logger;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import okhttp3.TlsVersion;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.io.File;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface ConfigFluent<A extends io.fabric8.kubernetes.client.ConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public boolean isTrustCerts();
    public A withTrustCerts(boolean trustCerts);
    public java.lang.Boolean hasTrustCerts();
    public boolean isDisableHostnameVerification();
    public A withDisableHostnameVerification(boolean disableHostnameVerification);
    public java.lang.Boolean hasDisableHostnameVerification();
    public java.lang.String getMasterUrl();
    public A withMasterUrl(java.lang.String masterUrl);
    public java.lang.Boolean hasMasterUrl();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMasterUrl instead.
     */
        public A withNewMasterUrl(java.lang.String arg0);
    public java.lang.String getApiVersion();
    public A withApiVersion(java.lang.String apiVersion);
    public java.lang.Boolean hasApiVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0);
    public java.lang.String getNamespace();
    public A withNamespace(java.lang.String namespace);
    public java.lang.Boolean hasNamespace();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNamespace instead.
     */
        public A withNewNamespace(java.lang.String arg0);
    public java.lang.String getCaCertFile();
    public A withCaCertFile(java.lang.String caCertFile);
    public java.lang.Boolean hasCaCertFile();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCaCertFile instead.
     */
        public A withNewCaCertFile(java.lang.String arg0);
    public java.lang.String getCaCertData();
    public A withCaCertData(java.lang.String caCertData);
    public java.lang.Boolean hasCaCertData();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCaCertData instead.
     */
        public A withNewCaCertData(java.lang.String arg0);
    public java.lang.String getClientCertFile();
    public A withClientCertFile(java.lang.String clientCertFile);
    public java.lang.Boolean hasClientCertFile();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientCertFile instead.
     */
        public A withNewClientCertFile(java.lang.String arg0);
    public java.lang.String getClientCertData();
    public A withClientCertData(java.lang.String clientCertData);
    public java.lang.Boolean hasClientCertData();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientCertData instead.
     */
        public A withNewClientCertData(java.lang.String arg0);
    public java.lang.String getClientKeyFile();
    public A withClientKeyFile(java.lang.String clientKeyFile);
    public java.lang.Boolean hasClientKeyFile();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyFile instead.
     */
        public A withNewClientKeyFile(java.lang.String arg0);
    public java.lang.String getClientKeyData();
    public A withClientKeyData(java.lang.String clientKeyData);
    public java.lang.Boolean hasClientKeyData();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyData instead.
     */
        public A withNewClientKeyData(java.lang.String arg0);
    public java.lang.String getClientKeyAlgo();
    public A withClientKeyAlgo(java.lang.String clientKeyAlgo);
    public java.lang.Boolean hasClientKeyAlgo();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyAlgo instead.
     */
        public A withNewClientKeyAlgo(java.lang.String arg0);
    public java.lang.String getClientKeyPassphrase();
    public A withClientKeyPassphrase(java.lang.String clientKeyPassphrase);
    public java.lang.Boolean hasClientKeyPassphrase();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyPassphrase instead.
     */
        public A withNewClientKeyPassphrase(java.lang.String arg0);
    public java.lang.String getTrustStoreFile();
    public A withTrustStoreFile(java.lang.String trustStoreFile);
    public java.lang.Boolean hasTrustStoreFile();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTrustStoreFile instead.
     */
        public A withNewTrustStoreFile(java.lang.String arg0);
    public java.lang.String getTrustStorePassphrase();
    public A withTrustStorePassphrase(java.lang.String trustStorePassphrase);
    public java.lang.Boolean hasTrustStorePassphrase();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTrustStorePassphrase instead.
     */
        public A withNewTrustStorePassphrase(java.lang.String arg0);
    public java.lang.String getKeyStoreFile();
    public A withKeyStoreFile(java.lang.String keyStoreFile);
    public java.lang.Boolean hasKeyStoreFile();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyStoreFile instead.
     */
        public A withNewKeyStoreFile(java.lang.String arg0);
    public java.lang.String getKeyStorePassphrase();
    public A withKeyStorePassphrase(java.lang.String keyStorePassphrase);
    public java.lang.Boolean hasKeyStorePassphrase();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyStorePassphrase instead.
     */
        public A withNewKeyStorePassphrase(java.lang.String arg0);
    public A addToContexts(int index,io.fabric8.kubernetes.api.model.NamedContext item);
    public A setToContexts(int index,io.fabric8.kubernetes.api.model.NamedContext item);
    public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
    public A addAllToContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items);
    public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
    public A removeAllFromContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items);
    public java.util.List<io.fabric8.kubernetes.api.model.NamedContext> getContexts();
    public io.fabric8.kubernetes.api.model.NamedContext getContext(int index);
    public io.fabric8.kubernetes.api.model.NamedContext getFirstContext();
    public io.fabric8.kubernetes.api.model.NamedContext getLastContext();
    public io.fabric8.kubernetes.api.model.NamedContext getMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContext> predicate);
    public java.lang.Boolean hasMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContext> predicate);
    public A withContexts(java.util.List<io.fabric8.kubernetes.api.model.NamedContext> contexts);
    public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts);
    public java.lang.Boolean hasContexts();
    public io.fabric8.kubernetes.api.model.NamedContext getCurrentContext();
    public A withCurrentContext(io.fabric8.kubernetes.api.model.NamedContext currentContext);
    public java.lang.Boolean hasCurrentContext();
    public java.lang.String getUsername();
    public A withUsername(java.lang.String username);
    public java.lang.Boolean hasUsername();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUsername instead.
     */
        public A withNewUsername(java.lang.String arg0);
    public java.lang.String getPassword();
    public A withPassword(java.lang.String password);
    public java.lang.Boolean hasPassword();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPassword instead.
     */
        public A withNewPassword(java.lang.String arg0);
    public java.lang.String getOauthToken();
    public A withOauthToken(java.lang.String oauthToken);
    public java.lang.Boolean hasOauthToken();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOauthToken instead.
     */
        public A withNewOauthToken(java.lang.String arg0);
    public int getWatchReconnectInterval();
    public A withWatchReconnectInterval(int watchReconnectInterval);
    public java.lang.Boolean hasWatchReconnectInterval();
    public int getWatchReconnectLimit();
    public A withWatchReconnectLimit(int watchReconnectLimit);
    public java.lang.Boolean hasWatchReconnectLimit();
    public int getConnectionTimeout();
    public A withConnectionTimeout(int connectionTimeout);
    public java.lang.Boolean hasConnectionTimeout();
    public int getRequestTimeout();
    public A withRequestTimeout(int requestTimeout);
    public java.lang.Boolean hasRequestTimeout();
    public long getRollingTimeout();
    public A withRollingTimeout(long rollingTimeout);
    public java.lang.Boolean hasRollingTimeout();
    public long getScaleTimeout();
    public A withScaleTimeout(long scaleTimeout);
    public java.lang.Boolean hasScaleTimeout();
    public int getLoggingInterval();
    public A withLoggingInterval(int loggingInterval);
    public java.lang.Boolean hasLoggingInterval();
    public long getWebsocketTimeout();
    public A withWebsocketTimeout(long websocketTimeout);
    public java.lang.Boolean hasWebsocketTimeout();
    public long getWebsocketPingInterval();
    public A withWebsocketPingInterval(long websocketPingInterval);
    public java.lang.Boolean hasWebsocketPingInterval();
    public int getMaxConcurrentRequests();
    public A withMaxConcurrentRequests(int maxConcurrentRequests);
    public java.lang.Boolean hasMaxConcurrentRequests();
    public int getMaxConcurrentRequestsPerHost();
    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost);
    public java.lang.Boolean hasMaxConcurrentRequestsPerHost();
    public java.lang.String getImpersonateUsername();
    public A withImpersonateUsername(java.lang.String impersonateUsername);
    public java.lang.Boolean hasImpersonateUsername();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImpersonateUsername instead.
     */
        public A withNewImpersonateUsername(java.lang.String arg0);
    public io.fabric8.kubernetes.client.OAuthTokenProvider getOauthTokenProvider();
    public A withOauthTokenProvider(io.fabric8.kubernetes.client.OAuthTokenProvider oauthTokenProvider);
    public java.lang.Boolean hasOauthTokenProvider();
    public java.lang.String getImpersonateGroup();
    public A withImpersonateGroup(java.lang.String impersonateGroup);
    public java.lang.Boolean hasImpersonateGroup();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImpersonateGroup instead.
     */
        public A withNewImpersonateGroup(java.lang.String arg0);
    public A withImpersonateGroups(java.lang.String... impersonateGroups);
    public java.lang.String[] getImpersonateGroups();
    public A addToImpersonateGroups(int index,java.lang.String item);
    public A setToImpersonateGroups(int index,java.lang.String item);
    public A addToImpersonateGroups(java.lang.String... items);
    public A addAllToImpersonateGroups(java.util.Collection<java.lang.String> items);
    public A removeFromImpersonateGroups(java.lang.String... items);
    public A removeAllFromImpersonateGroups(java.util.Collection<java.lang.String> items);
    public java.lang.Boolean hasImpersonateGroups();
    public A addNewImpersonateGroup(java.lang.String arg0);
    public A addToImpersonateExtras(java.lang.String key,java.util.List<java.lang.String> value);
    public A addToImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map);
    public A removeFromImpersonateExtras(java.lang.String key);
    public A removeFromImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map);
    public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getImpersonateExtras();
    public <K,V>A withImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> impersonateExtras);
    public java.lang.Boolean hasImpersonateExtras();
    public boolean isHttp2Disable();
    public A withHttp2Disable(boolean http2Disable);
    public java.lang.Boolean hasHttp2Disable();
    public java.lang.String getHttpProxy();
    public A withHttpProxy(java.lang.String httpProxy);
    public java.lang.Boolean hasHttpProxy();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHttpProxy instead.
     */
        public A withNewHttpProxy(java.lang.String arg0);
    public java.lang.String getHttpsProxy();
    public A withHttpsProxy(java.lang.String httpsProxy);
    public java.lang.Boolean hasHttpsProxy();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHttpsProxy instead.
     */
        public A withNewHttpsProxy(java.lang.String arg0);
    public java.lang.String getProxyUsername();
    public A withProxyUsername(java.lang.String proxyUsername);
    public java.lang.Boolean hasProxyUsername();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProxyUsername instead.
     */
        public A withNewProxyUsername(java.lang.String arg0);
    public java.lang.String getProxyPassword();
    public A withProxyPassword(java.lang.String proxyPassword);
    public java.lang.Boolean hasProxyPassword();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProxyPassword instead.
     */
        public A withNewProxyPassword(java.lang.String arg0);
    public A withNoProxy(java.lang.String... noProxy);
    public java.lang.String[] getNoProxy();
    public A addToNoProxy(int index,java.lang.String item);
    public A setToNoProxy(int index,java.lang.String item);
    public A addToNoProxy(java.lang.String... items);
    public A addAllToNoProxy(java.util.Collection<java.lang.String> items);
    public A removeFromNoProxy(java.lang.String... items);
    public A removeAllFromNoProxy(java.util.Collection<java.lang.String> items);
    public java.lang.Boolean hasNoProxy();
    public A addNewNoProxy(java.lang.String arg0);
    public java.lang.String getUserAgent();
    public A withUserAgent(java.lang.String userAgent);
    public java.lang.Boolean hasUserAgent();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserAgent instead.
     */
        public A withNewUserAgent(java.lang.String arg0);
    public A withTlsVersions(okhttp3.TlsVersion... tlsVersions);
    public okhttp3.TlsVersion[] getTlsVersions();
    public A addToTlsVersions(int index,okhttp3.TlsVersion item);
    public A setToTlsVersions(int index,okhttp3.TlsVersion item);
    public A addToTlsVersions(okhttp3.TlsVersion... items);
    public A addAllToTlsVersions(java.util.Collection<okhttp3.TlsVersion> items);
    public A removeFromTlsVersions(okhttp3.TlsVersion... items);
    public A removeAllFromTlsVersions(java.util.Collection<okhttp3.TlsVersion> items);
    public java.lang.Boolean hasTlsVersions();
    public A addToErrorMessages(java.lang.Integer key,java.lang.String value);
    public A addToErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> map);
    public A removeFromErrorMessages(java.lang.Integer key);
    public A removeFromErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> map);
    public java.util.Map<java.lang.Integer,java.lang.String> getErrorMessages();
    public <K,V>A withErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> errorMessages);
    public java.lang.Boolean hasErrorMessages();
    public A addToCustomHeaders(java.lang.String key,java.lang.String value);
    public A addToCustomHeaders(java.util.Map<java.lang.String,java.lang.String> map);
    public A removeFromCustomHeaders(java.lang.String key);
    public A removeFromCustomHeaders(java.util.Map<java.lang.String,java.lang.String> map);
    public java.util.Map<java.lang.String,java.lang.String> getCustomHeaders();
    public <K,V>A withCustomHeaders(java.util.Map<java.lang.String,java.lang.String> customHeaders);
    public java.lang.Boolean hasCustomHeaders();
}
