/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.cache.Controller;
import io.fabric8.kubernetes.client.informers.cache.DeltaFIFO;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class ControllerTest {
    private DeltaFIFO<Pod> deltaFIFO = (DeltaFIFO)Mockito.mock(DeltaFIFO.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private ListerWatcher<Pod, PodList> listerWatcher = (ListerWatcher)Mockito.mock(ListerWatcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private OperationContext operationContext = (OperationContext)Mockito.mock(OperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = (ConcurrentLinkedQueue)Mockito.mock(ConcurrentLinkedQueue.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    ControllerTest() {
    }

    @Test
    @DisplayName(value="Controller initialized with resync period greater than zero should use provided resync period")
    void testControllerCreationWithResyncPeriodMoreThanZero() {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, simpleEntries -> {}, () -> true, 1000L, this.operationContext, this.eventListeners);
        Assertions.assertEquals((long)1000L, (long)controller.getReflector().getResyncPeriodMillis());
    }

    @Test
    @DisplayName(value="Controller initialized with resync period less than zero should throw exception")
    void testControllerCreationWithResyncPeriodLessThanZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, simpleEntries -> {}, () -> true, -1000L, this.operationContext, this.eventListeners));
    }

    @Test
    @DisplayName(value="Controller initialized with resync period 0 should use provided resync period")
    void testControllerCreationWithResyncPeriodZero() {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, simpleEntries -> {}, () -> true, 0L, this.operationContext, this.eventListeners);
        Assertions.assertEquals((long)0L, (long)controller.getReflector().getResyncPeriodMillis());
    }
}

