/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class SharedInformerFactoryTest {
    private OkHttpClient mockClient;
    private Config config;
    private ExecutorService executorService;

    SharedInformerFactoryTest() {
    }

    @BeforeEach
    void init() {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.executorService = (ExecutorService)Mockito.mock(ExecutorService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void testGetInformerKey() {
        Assertions.assertThat((String)SharedInformerFactory.getInformerKey((OperationContext)new OperationContext().withApiGroupVersion("v1").withPlural("pods"))).isEqualTo("v1/pods");
        Assertions.assertThat((String)SharedInformerFactory.getInformerKey((OperationContext)new OperationContext().withApiGroupVersion("v1").withNamespace("ns1").withPlural("pods"))).isEqualTo("v1/pods/ns1");
        Assertions.assertThat((String)SharedInformerFactory.getInformerKey((OperationContext)new OperationContext().withApiGroupVersion("v1").withApiGroupName("io.fabric8").withPlural("testcustomresources"))).isEqualTo("io.fabric8/v1/testcustomresources");
        Assertions.assertThat((String)SharedInformerFactory.getInformerKey((OperationContext)new OperationContext().withApiGroupVersion("v1beta1").withApiGroupName("io.fabric8").withPlural("testcustomresources"))).isEqualTo("io.fabric8/v1beta1/testcustomresources");
        Assertions.assertThat((String)SharedInformerFactory.getInformerKey((OperationContext)new OperationContext().withApiGroupVersion("v1beta1").withApiGroupName("extensions").withPlural("deployments"))).isEqualTo("extensions/v1beta1/deployments");
    }

    @Test
    void testInformersCreatedWithSameNameButDifferentCRDContext() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        sharedInformerFactory.sharedIndexInformerForCustomResource(TestCustomResource.class, new OperationContext().withApiGroupVersion("v1").withPlural("testcustomresources"), 10000L);
        sharedInformerFactory.sharedIndexInformerForCustomResource(TestCustomResource.class, new OperationContext().withApiGroupVersion("v1beta1").withPlural("testcustomresources"), 10000L);
        Assertions.assertThat((Map)sharedInformerFactory.getInformers()).hasSize(2);
    }

    @Test
    void testGetExistingSharedIndexInformer() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        sharedInformerFactory.sharedIndexInformerFor(Deployment.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(Pod.class, 10000L);
        Assertions.assertThat((Object)sharedInformerFactory.getExistingSharedIndexInformer(Deployment.class)).isNotNull();
        Assertions.assertThat((Object)sharedInformerFactory.getExistingSharedIndexInformer(Pod.class)).isNotNull();
    }

    @Test
    void testGetExistingSharedIndexInformerWithKindDifferentFromClassName() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        SharedIndexInformer createdInformer = sharedInformerFactory.sharedIndexInformerFor(MyAppCustomResource.class, 10000L);
        SharedIndexInformer existingInformer = sharedInformerFactory.getExistingSharedIndexInformer(MyAppCustomResource.class);
        Assertions.assertThat((Object)createdInformer).isNotNull();
        Assertions.assertThat((Object)existingInformer).isNotNull();
        Assertions.assertThat((Object)createdInformer).isEqualTo((Object)existingInformer);
    }

    @Group(value="com.acme")
    @Version(value="v1")
    @Kind(value="MyApp")
    public static class MyAppCustomResource
    extends CustomResource<Void, Void> {
    }

    @Group(value="io.fabric8")
    @Version(value="v1")
    private static class TestCustomResource
    extends CustomResource<TestCustomResourceSpec, TestCustomResourceStatus> {
        private TestCustomResource() {
        }
    }

    private static class TestCustomResourceStatus {
        private TestCustomResourceStatus() {
        }
    }

    private static class TestCustomResourceSpec {
        private TestCustomResourceSpec() {
        }
    }
}

