/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.DeploymentOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AppsV1ControllerPodOperationTest {
    AppsV1ControllerPodOperationTest() {
    }

    @Test
    void testDeploymentSelectorLabels() {
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)new DeploymentBuilder().withNewSpec().withNewTemplate().withNewMetadata().addToLabels("foo", "bar")).addToLabels("one", "two")).endMetadata()).endTemplate()).endSpec()).build();
        Map labels = DeploymentOperationsImpl.getDeploymentSelectorLabels((Deployment)deployment);
        Assertions.assertNotNull((Object)labels);
        Assertions.assertEquals((int)deployment.getSpec().getTemplate().getMetadata().getLabels().size(), (int)labels.size());
        Assertions.assertEquals((Object)"bar", labels.get("foo"));
        Assertions.assertEquals((Object)"two", labels.get("one"));
    }

    @Test
    void testReplicaSetSelectorLabels() {
        ReplicaSet replicaSet = ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)new ReplicaSetBuilder().withNewSpec().withNewSelector().addToMatchLabels("foo", "bar")).endSelector()).endSpec()).build();
        Map labels = ReplicaSetOperationsImpl.getReplicaSetSelectorLabels((ReplicaSet)replicaSet);
        Assertions.assertNotNull((Object)labels);
        Assertions.assertEquals((int)replicaSet.getSpec().getSelector().getMatchLabels().size(), (int)labels.size());
        Assertions.assertEquals((Object)"bar", labels.get("foo"));
    }

    @Test
    void testStatefulSetSelectorLabels() {
        StatefulSet statefulSet = ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)new StatefulSetBuilder().withNewSpec().withNewTemplate().withNewMetadata().addToLabels("foo", "bar")).addToLabels("one", "two")).endMetadata()).endTemplate()).endSpec()).build();
        Map labels = StatefulSetOperationsImpl.getStatefulSetSelectorLabels((StatefulSet)statefulSet);
        Assertions.assertNotNull((Object)labels);
        Assertions.assertEquals((int)statefulSet.getSpec().getTemplate().getMetadata().getLabels().size(), (int)labels.size());
        Assertions.assertEquals((Object)"bar", labels.get("foo"));
        Assertions.assertEquals((Object)"two", labels.get("one"));
    }
}

