/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CustomResourceOperationsImplTest {
    private final CustomResourceDefinition crd = CustomResourceDefinitionContext.v1beta1CRDFromCustomResourceType(MyCustomResource.class).build();

    @Test
    void shouldBeAbleToReturnOperationsWithoutSpecificList() {
        MixedOperation operation = new DefaultKubernetesClient().customResources(Bar.class, CustomResourceList.class);
        Assert.assertNotNull((Object)operation);
    }

    @Test
    public void shouldRegisterWithKubernetesDeserializer() throws IOException {
        this.assertForContext(new CustomResourceOperationContext().withCrd(this.crd).withType(MyCustomResource.class).withListType(MyCustomResourceList.class));
    }

    @Test
    public void shouldWorkWithPlainCustomResourceList() throws IOException {
        this.assertForContext(new CustomResourceOperationContext().withCrd(this.crd).withType(MyCustomResource.class).withListType(CustomResourceList.class));
    }

    @Test
    void itFallsBackOnTypeKindIfNoKindSpecifiedInContext() throws IOException {
        this.assertForContext(new CustomResourceOperationContext().withCrdContext(new CustomResourceDefinitionContext.Builder().withGroup(this.crd.getSpec().getGroup()).withVersion(this.crd.getSpec().getVersion()).withScope(this.crd.getSpec().getScope()).withName(this.crd.getMetadata().getName()).withPlural(this.crd.getSpec().getNames().getPlural()).build()).withType(MyCustomResource.class).withListType(MyCustomResourceList.class));
    }

    private void assertForContext(CustomResourceOperationContext context) throws IOException {
        new CustomResourceOperationsImpl(context);
        MappingJsonFactory factory = new MappingJsonFactory();
        JsonParser parser = factory.createParser("{\n    \"apiVersion\": \"custom.group/v1alpha1\",\n    \"kind\": \"MyCustomResource\"\n}");
        KubernetesDeserializer deserializer = new KubernetesDeserializer();
        KubernetesResource resource = deserializer.deserialize(parser, null);
        Assert.assertThat((Object)resource, (Matcher)IsInstanceOf.instanceOf(MyCustomResource.class));
        Assert.assertEquals((Object)"custom.group/v1alpha1", (Object)((MyCustomResource)resource).getApiVersion());
    }

    @Group(value="sample.fabric8.io")
    @Version(value="v1")
    public static class Bar
    extends CustomResource {
    }

    public static class MyCustomResourceList
    extends CustomResourceList<MyCustomResource> {
    }

    @Group(value="custom.group")
    @Version(value="v1alpha1")
    public static class MyCustomResource
    extends CustomResource {
        public static final String GROUP = "custom.group";
        public static final String VERSION = "v1alpha1";
    }
}

