/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.Service;

public interface ServiceToURLProvider {
  enum ServiceToUrlImplPriority {
    FIRST(0), SECOND(1), THIRD(2), FOURTH(3), FIFTH(4);

    private final int value;

    ServiceToUrlImplPriority(final int newVal) {
      value = newVal;
    }

    public int getValue() { return value; }
  }

  int getPriority();

  String getURL(Service service, String portName, String namespace, KubernetesClient client);
}
