/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.DeleteAndCreateHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class DeleteAndCreateHelperTest {
    DeleteAndCreateHelperTest() {
    }

    @Test
    void testDeleteAndCreate() {
        AtomicBoolean wasPodDeleted = new AtomicBoolean(false);
        Function<Pod, Boolean> deletePodTask = p -> {
            wasPodDeleted.set(true);
            return true;
        };
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Pod)createPodTask.apply((Pod)ArgumentMatchers.any()))).thenReturn((Object)this.getPod());
        DeleteAndCreateHelper podDeleteAndCreateHelper = new DeleteAndCreateHelper(createPodTask, deletePodTask, p -> true);
        Pod podCreated = (Pod)podDeleteAndCreateHelper.deleteAndCreate((HasMetadata)this.getPod());
        Assert.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)wasPodDeleted.get());
    }

    @Test
    void testDeleteAndCreateWhenDeletionFailed() {
        AtomicBoolean wasPodDeleted = new AtomicBoolean(false);
        Function<Pod, Boolean> deletePodTask = p -> {
            wasPodDeleted.set(true);
            return false;
        };
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Pod)createPodTask.apply((Pod)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        DeleteAndCreateHelper podDeleteAndCreateHelper = new DeleteAndCreateHelper(createPodTask, deletePodTask, p -> {
            throw new RuntimeException("should not be called because creation will succeed first");
        });
        Pod podToDeleteAndCreate = this.getPod();
        Pod result = (Pod)podDeleteAndCreateHelper.deleteAndCreate((HasMetadata)podToDeleteAndCreate);
        Assert.assertEquals((Object)podToDeleteAndCreate, (Object)result);
        ((UnaryOperator)Mockito.verify((Object)createPodTask)).apply(podToDeleteAndCreate);
    }

    @Test
    void testThrowExceptionOnConflictAfterNoDelete() {
        AtomicBoolean wasPodDeleted = new AtomicBoolean(false);
        Function<Pod, Boolean> deletePodTask = p -> {
            wasPodDeleted.set(true);
            return false;
        };
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Pod)createPodTask.apply((Pod)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new KubernetesClientException("The POST operation could not be completed at this time, please try again", 409, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(409))).build())});
        DeleteAndCreateHelper podDeleteAndCreateHelper = new DeleteAndCreateHelper(createPodTask, deletePodTask, p -> {
            throw new RuntimeException("should not be called because creation will succeed first");
        });
        Pod podToDeleteAndCreate = this.getPod();
        Assertions.assertThrows(KubernetesClientException.class, () -> podDeleteAndCreateHelper.deleteAndCreate((HasMetadata)podToDeleteAndCreate));
    }

    @Test
    void testDeleteAndCreateWhenDeletionSucceedsButNotFinishedInTime() {
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Pod)createPodTask.apply((Pod)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new KubernetesClientException("The POST operation could not be completed at this time, please try again", 409, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(409))).build())});
        DeleteAndCreateHelper podDeleteAndCreateHelper = new DeleteAndCreateHelper(createPodTask, p -> true, p -> false);
        Pod podToDeleteAndCreate = this.getPod();
        Assertions.assertThrows(KubernetesClientException.class, () -> podDeleteAndCreateHelper.deleteAndCreate((HasMetadata)podToDeleteAndCreate));
    }

    @Test
    void testDeleteAndCreateAfterWaitingForItemToBeDeleted() {
        AtomicBoolean wasPodDeleted = new AtomicBoolean(false);
        Function<Pod, Boolean> deletePodTask = p -> {
            wasPodDeleted.set(true);
            return true;
        };
        AtomicBoolean awaitedDeletion = new AtomicBoolean(false);
        Function<Pod, Boolean> awaitDeletionTask = p -> {
            awaitedDeletion.set(true);
            return true;
        };
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Pod)createPodTask.apply((Pod)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new KubernetesClientException("The POST operation could not be completed at this time, please try again", 409, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(409))).build())}).thenReturn((Object)this.getPod());
        DeleteAndCreateHelper podDeleteAndCreateHelper = new DeleteAndCreateHelper(createPodTask, deletePodTask, awaitDeletionTask);
        Pod podCreated = (Pod)podDeleteAndCreateHelper.deleteAndCreate((HasMetadata)this.getPod());
        Assert.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)wasPodDeleted.get());
        Assertions.assertTrue((boolean)awaitedDeletion.get());
    }

    private Pod getPod() {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("p1")).endMetadata()).build();
    }
}

