/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.CreateOrReplaceHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class CreateOrReplaceHelperTest {
    CreateOrReplaceHelperTest() {
    }

    @Test
    void testCreateOrReplaceShouldCreate() {
        AtomicBoolean wasPodCreated = new AtomicBoolean(false);
        UnaryOperator createPodTask = p -> {
            wasPodCreated.set(true);
            return this.getPod();
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, p -> this.getPod(), p -> this.getPod(), p -> this.getPod());
        Pod podCreated = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)this.getPod());
        Assert.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)wasPodCreated.get());
    }

    @Test
    void testCreateOrReplaceShouldReplace() {
        AtomicBoolean wasPodReplaced = new AtomicBoolean(false);
        UnaryOperator createPodTask = p -> {
            throw new KubernetesClientException("Already exist", 409, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(409))).build());
        };
        UnaryOperator replacePodTask = p -> {
            wasPodReplaced.set(true);
            return this.getPod();
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, replacePodTask, p -> this.getPod(), p -> this.getPod());
        Pod podCreated = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)this.getPod());
        Assert.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)wasPodReplaced.get());
    }

    @Test
    void testCreateOrReplaceShouldRetryOnInternalServerError() {
        AtomicBoolean waitedForPod = new AtomicBoolean(false);
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        UnaryOperator reloadTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Pod)reloadTask.apply((Pod)ArgumentMatchers.any()))).thenReturn(null);
        Mockito.when((Object)((Pod)createPodTask.apply((Pod)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new KubernetesClientException("The POST operation could not be completed at this time, please try again", 500, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(500))).build())}).thenReturn((Object)this.getPod());
        UnaryOperator waitTask = p -> {
            waitedForPod.set(true);
            return this.getPod();
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, p -> this.getPod(), waitTask, reloadTask);
        Pod podCreated = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)this.getPod());
        Assert.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)waitedForPod.get());
    }

    @Test
    void testCreateOrReplaceThrowExceptionOnErrorCodeLessThan500() {
        UnaryOperator createPodTask = p -> {
            throw new KubernetesClientException("The POST operation could not be completed at this time, please try again", 400, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(400))).build());
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, p -> this.getPod(), p -> this.getPod(), p -> this.getPod());
        Pod podToCreate = this.getPod();
        Assertions.assertThrows(KubernetesClientException.class, () -> podCreateOrReplaceHelper.createOrReplace((HasMetadata)podToCreate));
    }

    private Pod getPod() {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("p1")).endMetadata()).build();
    }
}

