/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.cache.Reflector;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class ReflectorTest {
    ReflectorTest() {
    }

    @Test
    @DisplayName(value="Given Reflector with non zero resync period should invoke executorService")
    void testScheduleResyncExecutionWithNonZeroResyncPeriod() {
        ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Reflector<Pod, PodList> reflector = this.getReflectorWithResyncPeriod(1000L, executorService);
        reflector.scheduleResyncExecution();
        ((ScheduledExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.times((int)1))).scheduleWithFixedDelay((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1000L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    @DisplayName(value="Given Reflector with zero resync Period should not Then executorService is not invoked")
    void testScheduleResyncExecutionWithZeroResyncPeriod() {
        ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Reflector<Pod, PodList> reflector = this.getReflectorWithResyncPeriod(0L, executorService);
        reflector.scheduleResyncExecution();
        ((ScheduledExecutorService)Mockito.verify((Object)executorService, (VerificationMode)Mockito.times((int)0))).scheduleWithFixedDelay((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1000L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    private Reflector<Pod, PodList> getReflectorWithResyncPeriod(long resyncPeriodMillis, ScheduledExecutorService executorService) {
        ListerWatcher listerWatcher = (ListerWatcher)Mockito.mock(ListerWatcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Store store = (Store)Mockito.mock(Store.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        OperationContext operationContext = (OperationContext)Mockito.mock(OperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Reflector reflector = new Reflector(Pod.class, listerWatcher, store, operationContext, resyncPeriodMillis, executorService);
        return reflector;
    }
}

