/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DeleteOptionsBuilder;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class RawCustomResourceOperationsImplTest {
    private OkHttpClient mockClient;
    private Config config;
    private CustomResourceDefinitionContext namespacedCustomResourceDefinitionContext;
    private CustomResourceDefinitionContext clusterCustomResourceDefinitionContext;
    private Response mockSuccessResponse;

    @BeforeEach
    public void setUp() throws IOException {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.namespacedCustomResourceDefinitionContext = new CustomResourceDefinitionContext.Builder().withGroup("test.fabric8.io").withName("hellos.test.fabric8.io").withPlural("hellos").withScope("Namespaced").withVersion("v1alpha1").build();
        this.clusterCustomResourceDefinitionContext = new CustomResourceDefinitionContext.Builder().withGroup("test.fabric8.io").withName("hellos.test.fabric8.io").withPlural("hellos").withScope("Cluster").withVersion("v1alpha1").build();
        Call mockCall = (Call)Mockito.mock(Call.class);
        this.mockSuccessResponse = this.mockResponse(200);
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)this.mockSuccessResponse);
        Mockito.when((Object)this.mockClient.newCall((Request)Mockito.any())).thenReturn((Object)mockCall);
    }

    @Test
    void testCreateOrReplaceUrl() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        String resourceAsString = "{\"metadata\":{\"name\":\"myresource\",\"namespace\":\"myns\"}, \"kind\":\"raw\", \"apiVersion\":\"v1\"}";
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Call mockCall = (Call)Mockito.mock(Call.class);
        Response mockErrorResponse = this.mockResponse(500);
        Response mockConflictResponse = this.mockResponse(409);
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)mockErrorResponse, (Object[])new Response[]{mockConflictResponse, this.mockSuccessResponse});
        Mockito.when((Object)this.mockClient.newCall((Request)Mockito.any())).thenReturn((Object)mockCall);
        try {
            rawCustomResourceOperations.createOrReplace(resourceAsString);
            org.junit.jupiter.api.Assertions.fail((String)"expected first call to createOrReplace to throw exception due to 500 response");
        }
        catch (KubernetesClientException e) {
            org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)e.getCode());
        }
        rawCustomResourceOperations.createOrReplace(resourceAsString);
        rawCustomResourceOperations.createOrReplace("myns", resourceAsString);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)4))).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)captor.getAllValues().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/hellos", (Object)((Request)captor.getAllValues().get(0)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"POST", (Object)((Request)captor.getAllValues().get(0)).method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/hellos", (Object)((Request)captor.getAllValues().get(1)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"POST", (Object)((Request)captor.getAllValues().get(1)).method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/hellos/myresource", (Object)((Request)captor.getAllValues().get(2)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"PUT", (Object)((Request)captor.getAllValues().get(2)).method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", (Object)((Request)captor.getAllValues().get(3)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"POST", (Object)((Request)captor.getAllValues().get(3)).method());
    }

    @Test
    void testDeleteWithNamespaceAndNameForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", "foo");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceAndCascadingForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceAndDeleteOptionsForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withOrphanDependents(Boolean.valueOf(true))).build());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceNameAndCascading() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(200, "{\"kind\":\"Hello\",\"metadata\":{\"name\":\"Failure\"}}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", "foo", true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceNameAndCascadingForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", "foo", true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceNameAndPropagationPolicyForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", "foo", DeletionPropagation.BACKGROUND.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteWithNamespaceNameAndDeleteOptionsForNonExistentResource() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.mockDeletionCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        boolean result = rawCustomResourceOperations.delete("ns1", "foo", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withPropagationPolicy(DeletionPropagation.FOREGROUND.toString())).build());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testGetUrl() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.get("myns", "myresource");
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "GET");
    }

    @Test
    void testDeleteUrl() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        this.mockDeletionCallWithResponse(200, "{\"kind\":\"Status\",\"status\":\"Success\"}");
        boolean result = rawCustomResourceOperations.delete("myns", "myresource");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
    }

    @Test
    void testFetchWatchUrlWithNamespace() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.inNamespace("test").fetchWatchUrl(null, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithNamespaceAndName() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.inNamespace("test").withName("example-resource").fetchWatchUrl(null, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?fieldSelector=metadata.name%3Dexample-resource&watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithNamespaceAndNameAndResourceVersion() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.inNamespace("test").withName("example-resource").fetchWatchUrl(null, ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("100069")).withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?fieldSelector=metadata.name%3Dexample-resource&resourceVersion=100069&watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithoutAnything() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl(null, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/hellos?watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithLabels() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("foo", "bar");
        labels.put("foo1", "bar1");
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl(labels, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("https://localhost:8443/apis/test.fabric8.io/v1alpha1/hellos?labelSelector=" + Utils.toUrlEncoded((String)"foo=bar") + Utils.toUrlEncoded((String)",") + Utils.toUrlEncoded((String)"foo1=bar1") + "&watch=true"), (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithLabelsWithNamespace() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("foo", "bar");
        labels.put("foo1", "bar1");
        HttpUrl url = rawCustomResourceOperations.inNamespace("test").fetchWatchUrl(labels, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?labelSelector=" + Utils.toUrlEncoded((String)"foo=bar") + Utils.toUrlEncoded((String)",") + Utils.toUrlEncoded((String)"foo1=bar1") + "&watch=true"), (Object)url.url().toString());
    }

    @Test
    void testGetConfigShouldNotReturnNull() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withRequestTimeout(5)).withWebsocketTimeout(10L)).withWebsocketPingInterval(10L)).withConnectionTimeout(10)).withWatchReconnectLimit(1)).withWatchReconnectInterval(10)).build();
        RawCustomResourceOperationsImpl rawOp = new RawCustomResourceOperationsImpl(this.mockClient, config, this.namespacedCustomResourceDefinitionContext);
        Config configFromRawOp = rawOp.getConfig();
        Assertions.assertThat((Object)configFromRawOp).isNotNull();
        Assertions.assertThat((int)configFromRawOp.getRequestTimeout()).isEqualTo(5);
        Assertions.assertThat((long)configFromRawOp.getWebsocketTimeout()).isEqualTo(10L);
        Assertions.assertThat((long)configFromRawOp.getWebsocketPingInterval()).isEqualTo(10L);
        Assertions.assertThat((int)configFromRawOp.getConnectionTimeout()).isEqualTo(10L);
        Assertions.assertThat((int)configFromRawOp.getWatchReconnectInterval()).isEqualTo(10);
        Assertions.assertThat((int)configFromRawOp.getWatchReconnectLimit()).isEqualTo(1);
    }

    @Test
    void testDryRunDelete() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((RawCustomResourceOperationsImpl)rawCustomResourceOperations.dryRun()).delete("myns", "myresource");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", (Object)((Request)captor.getValue()).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dryRun=All", (Object)((Request)captor.getValue()).url().encodedQuery());
    }

    @Test
    void testDryRunCreate() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((RawCustomResourceOperationsImpl)rawCustomResourceOperations.dryRun()).create("myns", "{\"apiVersion\":\"test.fabric8.io/v1alpha1\"}");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", (Object)((Request)captor.getValue()).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dryRun=All", (Object)((Request)captor.getValue()).url().encodedQuery());
    }

    private void mockDeletionCallWithResponse(int code, String status) throws IOException {
        Call mockCall = (Call)Mockito.mock(Call.class);
        Response mockNotFoundResponse = this.mockResponse(code, status);
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)mockNotFoundResponse);
        Mockito.when((Object)this.mockClient.newCall((Request)Mockito.any())).thenReturn((Object)mockCall);
    }

    private Response mockResponse(int code) {
        return this.mockResponse(code, "{\"kind\":\"Status\",\"status\":\"Success\"}");
    }

    private Response mockResponse(int code, String body) {
        return new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(code).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)body)).message("mock").build();
    }

    @Test
    void testDeleteWithNamespaceAndName() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.inNamespace("myns").withName("myresource").delete();
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
    }

    @Test
    void testGet() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.inNamespace("myns").withName("myresource").get();
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "GET");
    }

    @Test
    void testListWithLimitAndContinue() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.inNamespace("myns").list(Integer.valueOf(4), "eyJ2IjoibWV0YS5rOHMuaW8vdj");
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"limit=4&continue=eyJ2IjoibWV0YS5rOHMuaW8vdj", (Object)((Request)captor.getValue()).url().encodedQuery());
    }

    @Test
    void testListWithListOptions() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.inNamespace("myns").list(((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(4L))).build());
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"limit=4", (Object)((Request)captor.getValue()).url().encodedQuery());
    }

    @Test
    void testListWithLabels() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.list("myns", Collections.singletonMap("foo", "bar"));
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"labelSelector=foo%3Dbar", (Object)((Request)captor.getValue()).url().encodedQuery());
    }

    @Test
    void testDeleteInSpecifiedNamespace() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.inNamespace("myns").delete();
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "DELETE");
    }

    @Test
    void testDeleteInAllNamespaces() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.inAnyNamespace().delete();
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/hellos", "DELETE");
    }

    @Test
    void testClusterScopedDeletionWithName() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.clusterCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.withName("myresource").delete();
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testClusterScopeDeletionAll() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.clusterCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete();
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/hellos", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithNamespacedScopedCRD() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myns");
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithCascadingWithNamespacedScopedCRD() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myns", true);
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithDeleteOptionsWithNamespacedScopedCRD() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myns", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withPropagationPolicy(DeletionPropagation.BACKGROUND.toString())).build());
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithClusterScopedCRD() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.clusterCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myresource");
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithCascadingWithClusterScopedCRD() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.clusterCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myresource", true);
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithDeleteOptionsWithClusterScopedCRD() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.clusterCustomResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myresource", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withPropagationPolicy(DeletionPropagation.BACKGROUND.toString())).build());
        this.assertRequestCaptured((ArgumentCaptor<Request>)captor, "/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    private void assertRequestCaptured(ArgumentCaptor<Request> captor, String url, String method) {
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)url, (Object)((Request)captor.getValue()).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)method, (Object)((Request)captor.getValue()).method());
    }
}

