/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.fabric8.kubernetes.client.utils.serialization.SettableBeanPropertyDelegate;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class SettableBeanPropertyDelegateTest {
    private SettableBeanProperty delegateMock;
    private SettableAnyProperty anySetterMock;
    private SettableBeanPropertyDelegate settableBeanPropertyDelegate;

    SettableBeanPropertyDelegateTest() {
    }

    @BeforeEach
    void setUp() {
        this.delegateMock = (SettableBeanProperty)Mockito.mock(SettableBeanProperty.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.anySetterMock = (SettableAnyProperty)Mockito.mock(SettableAnyProperty.class);
        this.settableBeanPropertyDelegate = new SettableBeanPropertyDelegate(this.delegateMock, this.anySetterMock, () -> false);
    }

    @Test
    @DisplayName(value="withValueDeserializer, should return a new instance")
    void withValueDeserializer() {
        ((SettableBeanProperty)Mockito.doReturn((Object)this.delegateMock).when((Object)this.delegateMock)).withValueDeserializer((JsonDeserializer)ArgumentMatchers.any());
        SettableBeanProperty result = this.settableBeanPropertyDelegate.withValueDeserializer(null);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(SettableBeanPropertyDelegate.class)).isNotSameAs((Object)this.settableBeanPropertyDelegate)).hasFieldOrPropertyWithValue("anySetter", (Object)this.anySetterMock)).hasFieldOrPropertyWithValue("delegate", (Object)this.delegateMock);
    }

    @Test
    @DisplayName(value="withName, should return a new instance")
    void withName() {
        ((SettableBeanProperty)Mockito.doReturn((Object)this.delegateMock).when((Object)this.delegateMock)).withName((PropertyName)ArgumentMatchers.any());
        SettableBeanProperty result = this.settableBeanPropertyDelegate.withName(null);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(SettableBeanPropertyDelegate.class)).isNotSameAs((Object)this.settableBeanPropertyDelegate)).hasFieldOrPropertyWithValue("anySetter", (Object)this.anySetterMock)).hasFieldOrPropertyWithValue("delegate", (Object)this.delegateMock);
    }

    @Test
    @DisplayName(value="withNullProvider, should return a new instance")
    void withNullProvider() {
        ((SettableBeanProperty)Mockito.doReturn((Object)this.delegateMock).when((Object)this.delegateMock)).withNullProvider((NullValueProvider)ArgumentMatchers.any());
        SettableBeanProperty result = this.settableBeanPropertyDelegate.withNullProvider(null);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(SettableBeanPropertyDelegate.class)).isNotSameAs((Object)this.settableBeanPropertyDelegate)).hasFieldOrPropertyWithValue("anySetter", (Object)this.anySetterMock)).hasFieldOrPropertyWithValue("delegate", (Object)this.delegateMock);
    }

    @Test
    @DisplayName(value="getMember, should return delegate's Member")
    void getMember() {
        Mockito.when((Object)this.delegateMock.getMember().getName()).thenReturn((Object)"the-member");
        String result = this.settableBeanPropertyDelegate.getMember().getName();
        Assertions.assertThat((String)result).isEqualTo("the-member");
    }

    @Test
    @DisplayName(value="getAnnotation, should return delegate's Annotation")
    void getAnnotation() {
        this.settableBeanPropertyDelegate.getAnnotation(null);
        ((SettableBeanProperty)Mockito.verify((Object)this.delegateMock, (VerificationMode)Mockito.times((int)1))).getAnnotation(null);
    }

    @Test
    @DisplayName(value="fixAccess, should invoke fixAccess in delegate")
    void fixAccess() {
        this.settableBeanPropertyDelegate.fixAccess(null);
        ((SettableBeanProperty)Mockito.verify((Object)this.delegateMock, (VerificationMode)Mockito.times((int)1))).fixAccess(null);
    }

    @Test
    @DisplayName(value="markAsIgnorable, should invoke markAsIgnorable in delegate")
    void markAsIgnorable() {
        this.settableBeanPropertyDelegate.markAsIgnorable();
        ((SettableBeanProperty)Mockito.verify((Object)this.delegateMock, (VerificationMode)Mockito.times((int)1))).markAsIgnorable();
    }

    @Test
    @DisplayName(value="isIgnorable, should return isIgnorable result in delegate")
    void isIgnorable() {
        Mockito.when((Object)this.delegateMock.isIgnorable()).thenReturn((Object)true);
        boolean result = this.settableBeanPropertyDelegate.isIgnorable();
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    @DisplayName(value="set, should set in delegate")
    void set() throws IOException {
        Object o1 = new Object();
        Object o2 = new Object();
        this.settableBeanPropertyDelegate.set(o1, o2);
        ((SettableBeanProperty)Mockito.verify((Object)this.delegateMock, (VerificationMode)Mockito.times((int)1))).set(o1, o2);
    }

    @Test
    @DisplayName(value="setAndReturn, should setAndReturn in delegate")
    void setAndReturn() throws IOException {
        Object o1 = new Object();
        Object o2 = new Object();
        this.settableBeanPropertyDelegate.setAndReturn(o1, o2);
        ((SettableBeanProperty)Mockito.verify((Object)this.delegateMock, (VerificationMode)Mockito.times((int)1))).setAndReturn(o1, o2);
    }

    @Test
    @DisplayName(value="deserializeSetAndReturn, should deserializeSetAndReturn in delegate")
    void deserializeSetAndReturn() throws IOException {
        Object instance = new Object();
        Mockito.when((Object)this.delegateMock.deserializeSetAndReturn((JsonParser)ArgumentMatchers.any(), (DeserializationContext)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)instance))).thenReturn((Object)"the-set-value");
        Object result = this.settableBeanPropertyDelegate.deserializeSetAndReturn(null, null, instance);
        Assertions.assertThat((Object)result).isEqualTo((Object)"the-set-value");
    }

    @Test
    @DisplayName(value="deserializeSetAndReturn, throws Exception, should try anySetter or rethrow")
    void deserializeSetAndReturnWithException() throws IOException {
        Object instance = new Object();
        Mockito.when((Object)this.delegateMock.getName()).thenReturn((Object)"the-property");
        Mockito.when((Object)this.delegateMock.deserializeSetAndReturn((JsonParser)ArgumentMatchers.any(), (DeserializationContext)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)instance))).thenThrow(new Throwable[]{MismatchedInputException.from(null, Integer.class, (String)"The Mocked Exception")});
        ((SettableBeanProperty)Mockito.doThrow((Throwable[])new Throwable[]{MismatchedInputException.from(null, Integer.class, (String)"The Mocked Exception")}).when((Object)this.delegateMock)).deserializeAndSet((JsonParser)ArgumentMatchers.any(), (DeserializationContext)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)instance));
        Object result = this.settableBeanPropertyDelegate.deserializeSetAndReturn((JsonParser)Mockito.mock(JsonParser.class), null, instance);
        Assertions.assertThat((Object)result).isNull();
        ((SettableAnyProperty)Mockito.verify((Object)this.anySetterMock, (VerificationMode)Mockito.times((int)1))).set(ArgumentMatchers.eq((Object)instance), ArgumentMatchers.eq((Object)"the-property"), ArgumentMatchers.any());
    }
}

