/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.MockHttpClientUtils;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TokenRefreshInterceptorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAutoconfigureAfter401() throws IOException {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-tokeninterceptor")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            boolean reissue = new TokenRefreshInterceptor(Config.autoConfigure(null), null).afterFailure(builder, MockHttpClientUtils.buildResponse(401, "foo"));
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer token");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAutoconfigureAfter1Minute() throws Exception {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            TokenRefreshInterceptor tokenRefreshInterceptor = new TokenRefreshInterceptor(Config.autoConfigure(null), null);
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig.new")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            tokenRefreshInterceptor.setLastRefresh(Instant.now().minus(61L, ChronoUnit.SECONDS));
            tokenRefreshInterceptor.before((BasicBuilder)builder, null);
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer new token");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="#4442 token auto refresh should not overwrite existing token when not applicable")
    void refreshShouldNotOverwriteExistingToken() throws Exception {
        try (MockedStatic configMock = Mockito.mockStatic(Config.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            Config autoConfig = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("")).build();
            configMock.when(() -> Config.autoConfigure((String)((String)ArgumentMatchers.any()))).thenReturn((Object)autoConfig);
            Config config = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("existing-token")).build();
            TokenRefreshInterceptor tokenRefreshInterceptor = new TokenRefreshInterceptor(config, null);
            tokenRefreshInterceptor.setLastRefresh(Instant.now().minusSeconds(61L));
            HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)response.code()).thenReturn((Object)401);
            boolean result = tokenRefreshInterceptor.afterFailure((BasicBuilder)Mockito.mock(BasicBuilder.class), response);
            Assertions.assertThat((boolean)result).isFalse();
            Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("oauthToken", (Object)"existing-token");
        }
    }

    @Test
    @DisplayName(value="#4442 token auto refresh should  overwrite existing token when applicable")
    void refreshShouldOverwriteExistingToken() throws Exception {
        try (MockedStatic configMock = Mockito.mockStatic(Config.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            Config autoConfig = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("new-token")).build();
            configMock.when(() -> Config.autoConfigure((String)((String)ArgumentMatchers.any()))).thenReturn((Object)autoConfig);
            Config config = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("existing-token")).build();
            TokenRefreshInterceptor tokenRefreshInterceptor = new TokenRefreshInterceptor(config, null);
            tokenRefreshInterceptor.setLastRefresh(Instant.now().minusSeconds(61L));
            HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)response.code()).thenReturn((Object)401);
            boolean result = tokenRefreshInterceptor.afterFailure((BasicBuilder)Mockito.mock(BasicBuilder.class), response);
            Assertions.assertThat((boolean)result).isTrue();
            Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("oauthToken", (Object)"new-token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReloadInClusterServiceAccount() throws IOException {
        try {
            File tokenFile = Files.createTempFile("test", "token", new FileAttribute[0]).toFile();
            Files.write(tokenFile.toPath(), "expired".getBytes(), new OpenOption[0]);
            System.setProperty("kubernetes.auth.serviceAccount.token", tokenFile.getAbsolutePath());
            System.setProperty("kubernetes.auth.tryKubeConfig", "false");
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(Config.autoConfigure(null), null);
            Files.write(tokenFile.toPath(), "renewed".getBytes(), new OpenOption[0]);
            boolean reissue = interceptor.afterFailure(builder, MockHttpClientUtils.buildResponse(401, "foo"));
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer renewed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubernetes.auth.serviceAccount.token");
            System.clearProperty("kubernetes.auth.tryKubeConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldRefreshOIDCToken() throws IOException {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            Config config = Config.autoConfigure(null);
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-tokeninterceptor-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(config, (HttpClient.Factory)Mockito.mock(HttpClient.Factory.class));
            boolean reissue = interceptor.afterFailure(builder, MockHttpClientUtils.buildResponse(401, "foo"));
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer renewed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }
}

