/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Objects;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class CertUtilsTest {
    private static final String FABRIC8_STORE_PATH = Utils.filePath((URL)CertUtilsTest.class.getResource("/ssl/fabric8-store"));
    private static final String FABRIC8_STORE_PASSPHRASE = "fabric8";
    private Properties systemProperties;

    CertUtilsTest() {
    }

    @BeforeEach
    public void storeSystemProperties() {
        this.systemProperties = new Properties();
        this.storeSystemProperty("javax.net.ssl.trustStore");
        this.storeSystemProperty("javax.net.ssl.trustStorePassword");
        this.storeSystemProperty("javax.net.ssl.trustStoreType");
        this.storeSystemProperty("javax.net.ssl.keyStore");
        this.storeSystemProperty("javax.net.ssl.keyStorePassword");
    }

    private void storeSystemProperty(String systemProperty) {
        String value = System.getProperty(systemProperty);
        if (Utils.isNotNullOrEmpty((String)value)) {
            this.systemProperties.put(systemProperty, value);
        }
    }

    @AfterEach
    public void resetSystemPropertiesBack() {
        System.setProperties(this.systemProperties);
    }

    @Disabled
    @Test
    void testLoadingDodgyKubeConfig() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, InvalidKeySpecException {
        System.setProperty("kubeconfig", "/tmp/ceposta.kubeconfig");
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        Config config = client.getConfiguration();
        KeyStore ts = CertUtils.createTrustStore((String)config.getCaCertData(), null, null, (String)"changeit");
        KeyStore ks = CertUtils.createKeyStore((String)config.getClientCertData(), null, (String)config.getClientKeyData(), null, (String)"RSA", (String)"changeit", null, (String)"changeit");
    }

    @Test
    void testLoadingMultipleCertsFromSameFile() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore ts = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl/multiple-certs.pem", null, (String)"changeit");
        Assertions.assertTrue((ts.size() >= 2 ? 1 : 0) != 0);
    }

    @Test
    void testLoadingMultipleCertsWithSameSubjectFromSameFile() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore ts = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl/nonunique-subject.pem", null, (String)"changeit");
        Assertions.assertTrue((ts.size() >= 2 ? 1 : 0) != 0);
    }

    @Test
    void testLoadTrustStoreFromFileUsingConfigProperties() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore trustStore = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl/multiple-certs.pem", (String)FABRIC8_STORE_PATH, (String)FABRIC8_STORE_PASSPHRASE);
        Assertions.assertEquals((int)3, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void testLoadTrustStoreFromFileUsingSystemProperties() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        System.setProperty("javax.net.ssl.trustStore", FABRIC8_STORE_PATH);
        System.setProperty("javax.net.ssl.trustStorePassword", FABRIC8_STORE_PASSPHRASE);
        KeyStore trustStore = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl/multiple-certs.pem", null, null);
        Assertions.assertEquals((int)3, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void testLoadKeyStoreFromFileUsingConfigProperties() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore trustStore = CertUtils.createKeyStore(null, (String)"src/test/resources/ssl/multiple-certs.pem", null, (String)"src/test/resources/ssl/fabric8", (String)"RSA", (String)"changeit", (String)FABRIC8_STORE_PATH, (String)FABRIC8_STORE_PASSPHRASE);
        Assertions.assertEquals((int)2, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void testLoadKeyStoreFromFileUsingSystemProperties() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, URISyntaxException {
        System.setProperty("javax.net.ssl.keyStore", FABRIC8_STORE_PATH);
        System.setProperty("javax.net.ssl.keyStorePassword", String.valueOf(FABRIC8_STORE_PASSPHRASE));
        String privateKeyPath = Utils.filePath((URL)this.getClass().getResource("/ssl/fabric8"));
        String multipleCertsPath = Utils.filePath((URL)this.getClass().getResource("/ssl/multiple-certs.pem"));
        KeyStore trustStore = CertUtils.createKeyStore(null, (String)multipleCertsPath, null, (String)privateKeyPath, (String)"RSA", (String)"changeit", null, null);
        Assertions.assertEquals((int)2, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void testGetInputStreamFromDataOrFileShouldNotDecodedPEMAgain() throws IOException {
        File certFile = new File(Objects.requireNonNull(this.getClass().getResource("/ssl/valid-non-base64-encoded-cert.pem")).getFile());
        String certData = new String(Files.readAllBytes(certFile.toPath()));
        InputStream inputStream = CertUtils.getInputStreamFromDataOrFile((String)certData, null);
        String certDataReadFromInputStream = IOHelpers.readFully((InputStream)inputStream);
        Assertions.assertEquals((Object)certData, (Object)certDataReadFromInputStream);
    }

    @Test
    void testGetInputStreamFromDataOrFileShouldDecodeBase64EncodedString() throws IOException {
        String inputStr = "this is a test";
        String base64EncodedStr = Base64.getEncoder().encodeToString(inputStr.getBytes());
        InputStream inputStream = CertUtils.getInputStreamFromDataOrFile((String)base64EncodedStr, null);
        String certDataReadFromInputStream = IOHelpers.readFully((InputStream)inputStream);
        Assertions.assertEquals((Object)inputStr, (Object)certDataReadFromInputStream);
    }

    private void verifyFabric8InStore(KeyStore trustStore) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        Certificate certificate = trustStore.getCertificate("fabric8-in-store");
        Assertions.assertNotNull((Object)certificate);
        KeyStore storeWithCert = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl/fabric8.crt", null, (String)"");
        String certificateAlias = storeWithCert.getCertificateAlias(certificate);
        Assertions.assertNotNull((Object)certificateAlias);
    }
}

