/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUploadWebSocketListener;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

class PodUploadWebSocketListenerTest {
    private PodUploadWebSocketListener podUploadWebSocketListener;

    PodUploadWebSocketListenerTest() {
    }

    @BeforeEach
    void setUp() {
        this.podUploadWebSocketListener = new PodUploadWebSocketListener();
    }

    @AfterEach
    void tearDown() {
        this.podUploadWebSocketListener = null;
    }

    @Test
    void testSendShouldTruncateAndSendFlaggedWebSocketData() {
        WebSocket mockedWebSocket = (WebSocket)Mockito.mock(WebSocket.class);
        this.podUploadWebSocketListener.onOpen(mockedWebSocket);
        byte[] toSend = new byte[]{1, 3, 3, 7, 0};
        this.podUploadWebSocketListener.send(toSend, 4);
        ((WebSocket)Mockito.verify((Object)mockedWebSocket, (VerificationMode)VerificationModeFactory.times((int)1))).send((ByteBuffer)ArgumentMatchers.eq((Object)ByteBuffer.wrap(new byte[]{0, 1, 3, 3, 7})));
    }

    @Test
    void testCheckErrorHasErrorFromMessageShouldThrowException() {
        this.podUploadWebSocketListener.onMessage(null, ByteBuffer.wrap("Error".getBytes()));
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podUploadWebSocketListener.checkError());
    }

    @Test
    void testCheckErrorHasErrorFromFailureShouldThrowException() {
        this.podUploadWebSocketListener.onError(null, (Throwable)new IOException("here"));
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podUploadWebSocketListener.checkError());
    }
}

