/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.MockHttpClientUtils;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class BaseOperationTest {
    BaseOperationTest() {
    }

    @Test
    void testSimpleFieldQueryParamConcatenation() {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("yesKey1", "yesValue1");
        fieldsMap.put("yesKey2", "yesValue2");
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext(), new OperationContext());
        operation = (PodOperationsImpl)((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withFields(fieldsMap).withField("yesKey2", "overrideValue2")).withoutField("noKey1", "noValue1")).withoutField("noKey2", "noValue2");
        String fieldQueryParam = operation.getFieldQueryParam();
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey1=yesValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey2=overrideValue2"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey1!=noValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey2!=noValue2"));
    }

    @Test
    void testSkippingFieldNotMatchingNullValues() {
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext(), new OperationContext());
        operation = (PodOperationsImpl)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withField("key1", "value1").withoutField("key2", "value2")).withoutField("key2", null)).withoutField("key2", "")).withoutField("key2", "value3")).withoutField("key10", "value11")).withoutField("key10", "");
        MatcherAssert.assertThat((Object)operation.getFieldQueryParam(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"key1=value1,key2!=value2,key2!=value3,key10!=value11")));
    }

    @Test
    void testFilterContextModification() {
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext(), new OperationContext());
        operation.withField("x", "y");
        Assertions.assertTrue((boolean)Utils.isNullOrEmpty((String)operation.getFieldQueryParam()));
    }

    @Test
    void testDefaultGracePeriod() {
        BaseOperation operation = new BaseOperation(new OperationContext());
        MatcherAssert.assertThat((Object)operation.getGracePeriodSeconds(), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    void testChainingGracePeriodAndPropagationPolicy() {
        BaseOperation operation = new BaseOperation(new OperationContext());
        EditReplacePatchDeletable operationWithPropagationPolicy = operation.withPropagationPolicy(DeletionPropagation.FOREGROUND);
        MatcherAssert.assertThat((Object)operationWithPropagationPolicy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assertions.assertNotNull((Object)operationWithPropagationPolicy.withGracePeriod(10L));
    }

    @Test
    void testListOptions() throws MalformedURLException {
        URL url = new URL("https://172.17.0.2:8443/api/v1/namespaces/default/pods");
        BaseOperation operation = new BaseOperation(new OperationContext());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&fieldSelector=status.phase%3DRunning"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withFieldSelector("status.phase=Running")).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&fieldSelector=status.phase%3DRunning&resourceVersion=210448"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withFieldSelector("status.phase=Running")).withResourceVersion("210448")).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&labelSelector=%21node-role.kubernetes.io%2Fmaster&resourceVersion=210448"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&labelSelector=%21node-role.kubernetes.io%2Fmaster&resourceVersion=210448&timeoutSeconds=10"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&labelSelector=%21node-role.kubernetes.io%2Fmaster&resourceVersion=210448&timeoutSeconds=10&allowWatchBookmarks=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).withAllowWatchBookmarks(Boolean.valueOf(true))).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&labelSelector=%21node-role.kubernetes.io%2Fmaster&resourceVersion=210448&timeoutSeconds=10&allowWatchBookmarks=true&watch=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).withAllowWatchBookmarks(Boolean.valueOf(true))).withWatch(Boolean.valueOf(true))).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?resourceVersion=210448"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("210448")).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?timeoutSeconds=10"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withTimeoutSeconds(Long.valueOf(10L))).build()).toString());
        Assertions.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?watch=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).toString());
    }

    @Test
    void testGetWriteOperationUrlWithDryRunEnabled() throws MalformedURLException {
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods").withDryRun(true));
        baseOp.setType(Pod.class);
        baseOp.setListType(PodList.class);
        URL result = baseOp.getResourceURLForWriteOperation(new URL("https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo?dryRun=All", (Object)result.toString());
    }

    @Test
    void testGetWriteOperationUrlWithDryRunDisabled() throws MalformedURLException {
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods"));
        baseOp.setType(Pod.class);
        baseOp.setListType(PodList.class);
        URL result = baseOp.getResourceURLForWriteOperation(new URL("https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo", (Object)result.toString());
    }

    private HttpClient newHttpClientWithSomeFailures(AtomicInteger httpExecutionCounter, int numFailures) throws IOException {
        HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HttpRequest.Builder mockRequestBuilder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
        HttpRequest request = MockHttpClientUtils.buildRequest();
        Mockito.when((Object)mockClient.newHttpRequestBuilder()).thenReturn((Object)mockRequestBuilder);
        Mockito.when((Object)mockRequestBuilder.build()).thenReturn((Object)request);
        Mockito.when((Object)mockClient.send((HttpRequest)Mockito.any(), (Class)Mockito.eq(InputStream.class))).thenAnswer(invocation -> {
            int count = httpExecutionCounter.getAndIncrement();
            if (count < numFailures) {
                if (count % 2 == 0) {
                    throw new IOException("For example java.net.ConnectException");
                }
                return MockHttpClientUtils.buildResponse(500);
            }
            Pod podNoLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
            return MockHttpClientUtils.buildResponse(200, Serialization.asJson((Object)podNoLabels));
        });
        return mockClient;
    }

    @Test
    void testNoHttpRetryWithDefaultConfig() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        HttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 1000);
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods").withName("test-pod").withHttpClient(mockClient));
        baseOp.setType(Pod.class);
        Exception exception = (Exception)Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod result = (Pod)baseOp.get();
        });
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("For example java.net.ConnectException"), (String)"As the first failure is an IOException the message of the causedBy expected to contain the given text: 'For example java.net.ConnectException'!");
        Assertions.assertEquals((int)1, (int)httpExecutionCounter.get());
    }

    @Test
    void testHttpRetryWithMoreFailuresThanRetries() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        HttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 1000);
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).withRequestRetryBackoffLimit(3)).build()).withPlural("pods").withName("test-pod").withHttpClient(mockClient));
        baseOp.setType(Pod.class);
        Exception exception = (Exception)Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod result = (Pod)baseOp.get();
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Internal Server Error"), (String)"As the last failure, the 3rd one, is not an IOException the message expected to contain: 'Internal Server Error'!");
        Assertions.assertEquals((int)4, (int)httpExecutionCounter.get(), (String)"Expected 4 calls: one normal try and 3 backoff retries!");
    }

    @Test
    void testHttpRetryWithLessFailuresThanRetries() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        HttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 2);
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).withRequestRetryBackoffLimit(3)).build()).withPlural("pods").withName("test-pod").withHttpClient(mockClient));
        baseOp.setType(Pod.class);
        Pod result = (Pod)baseOp.get();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)3, (int)httpExecutionCounter.get(), (String)"Expected 3 calls: 2 failures and 1 success!");
    }

    @Test
    void testWaitUntilFailureCompletion() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        HttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 2);
        final CompletableFuture future = new CompletableFuture();
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods").withName("test-pod").withHttpClient(mockClient)){

            public CompletableFuture<List<Pod>> informOnCondition(Predicate condition) {
                return future;
            }
        };
        baseOp.setType(Pod.class);
        try {
            baseOp.waitUntilCondition(Objects::isNull, 1L, TimeUnit.MILLISECONDS);
            Assertions.fail((String)"should timeout");
        }
        catch (KubernetesClientTimeoutException kubernetesClientTimeoutException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)future.isCancelled());
    }
}

