/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecConfigBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.lib.FileSystem;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigTest {
    private static final String TEST_KUBECONFIG_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig"));
    private static final String TEST_EC_KUBECONFIG_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-ec-kubeconfig"));
    private static final String TEST_NAMESPACE_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-namespace"));
    private static final String TEST_CONFIG_YML_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-config.yml"));
    private static final String TEST_KUBECONFIG_EXEC_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec"));
    private static final String TEST_TOKEN_GENERATOR_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/token-generator"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-null-args"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-null-args"));
    private static final String TEST_KUBECONFIG_NO_CURRENT_CONTEXT_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-nocurrentctxt.yml"));

    @BeforeEach
    public void setUp() {
        System.getProperties().remove("kubernetes.master");
        System.getProperties().remove("kubernetes.namespace");
        System.getProperties().remove("kubernetes.auth.token");
        System.getProperties().remove("kubernetes.auth.basic.username");
        System.getProperties().remove("kubernetes.auth.basic.password");
        System.getProperties().remove("kubernetes.trust.certificates");
        System.getProperties().remove("kubernetes.disable.hostname.verification");
        System.getProperties().remove("kubernetes.certs.ca.file");
        System.getProperties().remove("kubernetes.certs.ca.data");
        System.getProperties().remove("kubernetes.certs.client.file");
        System.getProperties().remove("kubernetes.certs.client.data");
        System.getProperties().remove("kubernetes.certs.client.key.file");
        System.getProperties().remove("kubernetes.certs.client.key.data");
        System.getProperties().remove("kubernetes.certs.client.key.algo");
        System.getProperties().remove("kubernetes.certs.client.key.passphrase");
        System.getProperties().remove("kubernetes.certs.client.key.file");
        System.getProperties().remove("kubernetes.max.concurrent.requests");
        System.getProperties().remove("kubernetes.max.concurrent.requests.per.host");
        System.getProperties().remove("kubernetes.watch.reconnectInterval");
        System.getProperties().remove("kubernetes.watch.reconnectLimit");
        System.getProperties().remove("kubernetes.request.timeout");
        System.getProperties().remove("http.proxy");
        System.getProperties().remove("kubeconfig");
        System.getProperties().remove("kubenamespace");
        System.getProperties().remove("kubernetes.tls.versions");
        System.getProperties().remove("kubernetes.truststore.file");
        System.getProperties().remove("kubernetes.truststore.passphrase");
        System.getProperties().remove("kubernetes.keystore.file");
        System.getProperties().remove("kubernetes.keystore.passphrase");
        System.getProperties().remove("KUBERNETES_SERVICE_HOST");
        System.getProperties().remove("KUBERNETES_SERVICE_PORT");
        System.getProperties().remove("kubernetes.impersonate.username");
        System.getProperties().remove("kubernetes.impersonate.group");
    }

    @AfterEach
    public void tearDown() {
        this.setUp();
    }

    @Test
    void testWithSystemProperties() {
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "testns");
        System.setProperty("kubernetes.auth.token", "token");
        System.setProperty("kubernetes.auth.basic.username", "user");
        System.setProperty("kubernetes.auth.basic.password", "pass");
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.disable.hostname.verification", "true");
        System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
        System.setProperty("kubernetes.certs.ca.data", "cacertdata");
        System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
        System.setProperty("kubernetes.certs.client.data", "clientcertdata");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
        System.setProperty("kubernetes.certs.client.key.algo", "algo");
        System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.max.concurrent.requests", "120");
        System.setProperty("kubernetes.max.concurrent.requests.per.host", "20");
        System.setProperty("kubernetes.watch.reconnectInterval", "5000");
        System.setProperty("kubernetes.watch.reconnectLimit", "5");
        System.setProperty("kubernetes.request.timeout", "5000");
        System.setProperty("http.proxy", "httpProxy");
        System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
        System.setProperty("kubernetes.truststore.file", "/path/to/truststore");
        System.setProperty("kubernetes.truststore.passphrase", "truststorePassphrase");
        System.setProperty("kubernetes.keystore.file", "/path/to/keystore");
        System.setProperty("kubernetes.keystore.passphrase", "keystorePassphrase");
        System.setProperty("kubernetes.upload.connection.timeout", "60000");
        System.setProperty("kubernetes.upload.request.timeout", "600000");
        Config config = new Config();
        this.assertConfig(config);
        config = new ConfigBuilder().build();
        this.assertConfig(config);
    }

    @Test
    void testWithBuilder() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withApiVersion("v1")).withNamespace("testns")).withOauthToken("token")).withUsername("user")).withPassword("pass")).withTrustCerts(true)).withDisableHostnameVerification(true)).withCaCertFile("/path/to/cert")).withCaCertData("cacertdata")).withClientCertFile("/path/to/clientcert")).withClientCertData("clientcertdata")).withClientKeyFile("/path/to/clientkey")).withClientKeyData("clientkeydata")).withClientKeyAlgo("algo")).withClientKeyPassphrase("passphrase")).withMaxConcurrentRequests(120)).withMaxConcurrentRequestsPerHost(20)).withWatchReconnectInterval(5000)).withWatchReconnectLimit(5)).withRequestTimeout(5000)).withUploadConnectionTimeout(60000)).withUploadRequestTimeout(600000)).withHttpProxy("httpProxy")).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).withTrustStoreFile("/path/to/truststore")).withTrustStorePassphrase("truststorePassphrase")).withKeyStoreFile("/path/to/keystore")).withKeyStorePassphrase("keystorePassphrase")).build();
        this.assertConfig(config);
    }

    @Test
    void testWithBuilderAndSystemProperties() {
        System.setProperty("kubernetes.master", "http://tobeoverriden:80");
        System.setProperty("kubernetes.namespace", "tobeoverriden");
        System.setProperty("kubernetes.auth.token", "token");
        System.setProperty("kubernetes.auth.basic.username", "user");
        System.setProperty("kubernetes.auth.basic.password", "pass");
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.disable.hostname.verification", "true");
        System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
        System.setProperty("kubernetes.certs.ca.data", "cacertdata");
        System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
        System.setProperty("kubernetes.certs.client.data", "clientcertdata");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
        System.setProperty("kubernetes.certs.client.key.algo", "algo");
        System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.max.concurrent.requests", "120");
        System.setProperty("kubernetes.max.concurrent.requests.per.host", "20");
        System.setProperty("kubernetes.watch.reconnectInterval", "5000");
        System.setProperty("kubernetes.watch.reconnectLimit", "5");
        System.setProperty("kubernetes.request.timeout", "5000");
        System.setProperty("http.proxy", "httpProxy");
        System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
        System.setProperty("kubernetes.truststore.file", "/path/to/truststore");
        System.setProperty("kubernetes.truststore.passphrase", "truststorePassphrase");
        System.setProperty("kubernetes.keystore.file", "/path/to/keystore");
        System.setProperty("kubernetes.keystore.passphrase", "keystorePassphrase");
        System.setProperty("kubernetes.upload.connection.timeout", "60000");
        System.setProperty("kubernetes.upload.request.timeout", "600000");
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withNamespace("testns")).build();
        this.assertConfig(config);
    }

    @Test
    void testMasterUrlWithServiceAccount() {
        System.setProperty("kubeconfig", "/dev/null");
        System.setProperty("KUBERNETES_SERVICE_HOST", "10.0.0.1");
        System.setProperty("KUBERNETES_SERVICE_PORT", "443");
        Config config = Config.autoConfigure(null);
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"https://10.0.0.1:443/", (Object)config.getMasterUrl());
        Assertions.assertEquals(null, (Object)config.getFile());
    }

    @Test
    void testMasterUrlWithServiceAccountIPv6() {
        System.setProperty("kubeconfig", "/dev/null");
        System.setProperty("KUBERNETES_SERVICE_HOST", "2001:db8:1f70::999:de8:7648:6e8");
        System.setProperty("KUBERNETES_SERVICE_PORT", "443");
        Config config = Config.autoConfigure(null);
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"https://[2001:db8:1f70::999:de8:7648:6e8]:443/", (Object)config.getMasterUrl());
        Assertions.assertEquals(null, (Object)config.getFile());
    }

    @Test
    void testWithKubeConfig() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        Config config = new Config();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assertions.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assertions.assertTrue((boolean)config.getCaCertFile().endsWith("testns/ca.pem".replace("/", File.separator)));
        Assertions.assertTrue((boolean)new File(config.getCaCertFile()).isAbsolute());
        Assertions.assertEquals((Object)new File(TEST_KUBECONFIG_FILE), (Object)config.getFile());
    }

    @Test
    void testWithKubeConfigAndOverrideContext() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/root");
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"production", (Object)config.getNamespace());
        Assertions.assertEquals((Object)"supertoken", (Object)config.getOauthToken());
        Assertions.assertTrue((boolean)config.getCaCertFile().endsWith("testns/ca.pem".replace("/", File.separator)));
        Assertions.assertTrue((boolean)new File(config.getCaCertFile()).isAbsolute());
    }

    @Test
    void testWithMultipleKubeConfigAndOverrideContext() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE + File.pathSeparator + "some-other-file");
        Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/root");
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"production", (Object)config.getNamespace());
        Assertions.assertEquals((Object)"supertoken", (Object)config.getOauthToken());
        Assertions.assertTrue((boolean)config.getCaCertFile().endsWith("testns/ca.pem".replace("/", File.separator)));
        Assertions.assertTrue((boolean)new File(config.getCaCertFile()).isAbsolute());
    }

    @Test
    void testWithKubeConfigAndSystemProperties() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assertions.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assertions.assertEquals((Object)new File(TEST_KUBECONFIG_FILE), (Object)config.getFile());
    }

    @Test
    void testWithKubeConfigAndSytemPropertiesAndBuilder() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assertions.assertEquals((Object)"testns2", (Object)config.getNamespace());
    }

    @Test
    void testFromKubeconfigContent() throws IOException {
        File configFile = new File(TEST_KUBECONFIG_FILE);
        String configYAML = String.join((CharSequence)"\n", Files.readAllLines(configFile.toPath()));
        Config config = Config.fromKubeconfig((String)configYAML);
        Assertions.assertEquals((Object)"https://172.28.128.4:8443", (Object)config.getMasterUrl());
    }

    @Test
    void testFromKubeconfigKeyAlgo() throws IOException {
        File configFile = new File(TEST_EC_KUBECONFIG_FILE);
        String configYAML = String.join((CharSequence)"\n", Files.readAllLines(configFile.toPath()));
        Config config = Config.fromKubeconfig((String)configYAML);
        Assertions.assertEquals((Object)"EC", (Object)config.getClientKeyAlgo());
    }

    @Test
    void testWithNamespacePath() {
        System.setProperty("kubeconfig", "nokubeconfigfile");
        System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"testnsfrompath", (Object)config.getNamespace());
    }

    @Test
    void testWithNonExistingNamespacePath() {
        System.setProperty("kubeconfig", "nokubeconfigfile");
        System.setProperty("kubenamespace", "nonamespace");
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertNull((Object)config.getNamespace());
    }

    @Test
    void testWithNamespacePathAndSystemProperties() {
        System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "testns");
        Config config = new Config();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"testns", (Object)config.getNamespace());
    }

    @Test
    void testWithKubeConfigAndNoContext() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_NO_CURRENT_CONTEXT_FILE);
        Config config = new Config();
        Assertions.assertNotNull((Object)config);
        Assertions.assertNull((Object)config.getCurrentContext());
        Assertions.assertEquals((int)3, (int)config.getContexts().size());
        Assertions.assertEquals((Object)"https://kubernetes.default.svc/", (Object)config.getMasterUrl());
        Assertions.assertNull((Object)config.getNamespace());
    }

    @Test
    void testWithNamespacePathAndSytemPropertiesAndBuilder() {
        System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "tobeoverriden");
        Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"testns2", (Object)config.getNamespace());
    }

    @Test
    void testWithCustomHeader() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("user-id", "test-user");
        customHeaders.put("cluster-id", "test-cluster");
        Config config = ((ConfigBuilder)new ConfigBuilder().withCustomHeaders(customHeaders)).build();
        Assertions.assertNotNull((Object)config);
        Assertions.assertNotNull((Object)config.getCustomHeaders());
        Assertions.assertEquals((int)2, (int)config.getCustomHeaders().size());
    }

    @Test
    void shouldSetImpersonateUsernameAndGroupFromSystemProperty() {
        System.setProperty("kubernetes.impersonate.username", "username");
        System.setProperty("kubernetes.impersonate.group", "group");
        HashMap<String, List<String>> extras = new HashMap<String, List<String>>();
        extras.put("c", Collections.singletonList("d"));
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withImpersonateUsername("a")).withImpersonateExtras(extras)).build();
        Assertions.assertEquals((Object)"a", (Object)config.getImpersonateUsername());
        Assertions.assertArrayEquals((Object[])new String[]{"group"}, (Object[])config.getImpersonateGroups());
        Assertions.assertEquals(Collections.singletonList("d"), config.getImpersonateExtras().get("c"));
    }

    @Test
    void shouldInstantiateClientUsingYaml() {
        File configYml = new File(TEST_CONFIG_YML_FILE);
        try (FileInputStream is = new FileInputStream(configYml);){
            DefaultKubernetesClient client = DefaultKubernetesClient.fromConfig((InputStream)is);
            Assertions.assertEquals((Object)"http://some.url", (Object)client.getMasterUrl().toString());
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void shouldInstantiateClientUsingSerializeDeserialize() {
        DefaultKubernetesClient original = new DefaultKubernetesClient();
        String json = Serialization.asJson((Object)original.getConfiguration());
        DefaultKubernetesClient copy = DefaultKubernetesClient.fromConfig((String)json);
        Assertions.assertEquals((Object)original.getConfiguration().getMasterUrl(), (Object)copy.getConfiguration().getMasterUrl());
        Assertions.assertEquals((Object)original.getConfiguration().getOauthToken(), (Object)copy.getConfiguration().getOauthToken());
        Assertions.assertEquals((Object)original.getConfiguration().getNamespace(), (Object)copy.getConfiguration().getNamespace());
        Assertions.assertEquals((Object)original.getConfiguration().getUsername(), (Object)copy.getConfiguration().getUsername());
        Assertions.assertEquals((Object)original.getConfiguration().getPassword(), (Object)copy.getConfiguration().getPassword());
    }

    @Test
    void shouldPropagateImpersonateSettings() {
        HashMap<String, List<String>> extras = new HashMap<String, List<String>>();
        extras.put("c", Collections.singletonList("d"));
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withImpersonateUsername("a")).withImpersonateGroup("b")).withImpersonateExtras(extras)).build();
        DefaultKubernetesClient client = new DefaultKubernetesClient(config);
        Config currentConfig = client.getConfiguration();
        Assertions.assertEquals((Object)"a", (Object)currentConfig.getImpersonateUsername());
        Assertions.assertArrayEquals((Object[])new String[]{"b"}, (Object[])currentConfig.getImpersonateGroups());
        Assertions.assertEquals(Collections.singletonList("d"), currentConfig.getImpersonateExtras().get("c"));
    }

    @Test
    void honorClientAuthenticatorCommands() throws Exception {
        switch (FileSystem.getCurrent()) {
            case WINDOWS: {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE);
                break;
            }
            default: {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE);
            }
        }
        Config config = Config.autoConfigure(null);
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)config.getOauthToken());
    }

    @Test
    void should_accept_client_authentication_commands_with_null_args() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS);
            }
            Config config = Config.autoConfigure(null);
            Assertions.assertNotNull((Object)config);
            Assertions.assertEquals((Object)"HELLO", (Object)config.getOauthToken());
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void shouldBeUsedTokenSuppliedByProvider() {
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withOauthToken("oauthToken")).withOauthTokenProvider(() -> "PROVIDER_TOKEN")).build();
        Assertions.assertEquals((Object)"PROVIDER_TOKEN", (Object)config.getOauthToken());
    }

    @Test
    void shouldHonorDefaultWebsocketPingInterval() {
        Config config = new ConfigBuilder().build();
        Assertions.assertEquals((long)30000L, (long)config.getWebsocketPingInterval());
    }

    @Test
    void testKubeConfigWithAuthConfigProvider() throws URISyntaxException {
        System.setProperty("kubeconfig", new File(this.getClass().getResource("/test-kubeconfig").toURI()).getAbsolutePath());
        Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/mmosley");
        Assertions.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"eyJraWQiOiJDTj1vaWRjaWRwLnRyZW1vbG8ubGFuLCBPVT1EZW1vLCBPPVRybWVvbG8gU2VjdXJpdHksIEw9QXJsaW5ndG9uLCBTVD1WaXJnaW5pYSwgQz1VUy1DTj1rdWJlLWNhLTEyMDIxNDc5MjEwMzYwNzMyMTUyIiwiYWxnIjoiUlMyNTYifQ.eyJpc3MiOiJodHRwczovL29pZGNpZHAudHJlbW9sby5sYW46ODQ0My9hdXRoL2lkcC9PaWRjSWRQIiwiYXVkIjoia3ViZXJuZXRlcyIsImV4cCI6MTQ4MzU0OTUxMSwianRpIjoiMm96US15TXdFcHV4WDlHZUhQdy1hZyIsImlhdCI6MTQ4MzU0OTQ1MSwibmJmIjoxNDgzNTQ5MzMxLCJzdWIiOiI0YWViMzdiYS1iNjQ1LTQ4ZmQtYWIzMC0xYTAxZWU0MWUyMTgifQ.w6p4J_6qQ1HzTG9nrEOrubxIMb9K5hzcMPxc9IxPx2K4xO9l-oFiUw93daH3m5pluP6K7eOE6txBuRVfEcpJSwlelsOsW8gb8VJcnzMS9EnZpeA0tW_p-mnkFc3VcfyXuhe5R3G7aa5d8uHv70yJ9Y3-UhjiN9EhpMdfPAoEB9fYKKkJRzF7utTTIPGrSaSU6d2pcpfYKaxIwePzEkT4DfcQthoZdy9ucNvvLoi1DIC-UocFD8HLs8LYKEqSxQvOcvnThbObJ9af71EwmuE21fO5KzMW20KtAeget1gnldOosPtz1G5EwvaQ401-RPQzPGMVBld0_zMCAwZttJ4knw", (Object)config.getOauthToken());
    }

    @Test
    void testEmptyConfig() {
        Config emptyConfig = null;
        emptyConfig = Config.empty();
        Assertions.assertNotNull((Object)emptyConfig);
        Assertions.assertEquals((Object)"https://kubernetes.default.svc", (Object)emptyConfig.getMasterUrl());
        Assertions.assertTrue((boolean)emptyConfig.getContexts().isEmpty());
        Assertions.assertNull((Object)emptyConfig.getCurrentContext());
        Assertions.assertEquals((int)64, (int)emptyConfig.getMaxConcurrentRequests());
        Assertions.assertEquals((int)5, (int)emptyConfig.getMaxConcurrentRequestsPerHost());
        Assertions.assertFalse((boolean)emptyConfig.isTrustCerts());
        Assertions.assertFalse((boolean)emptyConfig.isDisableHostnameVerification());
        Assertions.assertEquals((Object)"RSA", (Object)emptyConfig.getClientKeyAlgo());
        Assertions.assertEquals((Object)"changeit", (Object)emptyConfig.getClientKeyPassphrase());
        Assertions.assertEquals((int)1000, (int)emptyConfig.getWatchReconnectInterval());
        Assertions.assertEquals((int)-1, (int)emptyConfig.getWatchReconnectLimit());
        Assertions.assertEquals((int)10000, (int)emptyConfig.getConnectionTimeout());
        Assertions.assertEquals((int)10000, (int)emptyConfig.getRequestTimeout());
        Assertions.assertEquals((long)900000L, (long)emptyConfig.getRollingTimeout());
        Assertions.assertEquals((long)600000L, (long)emptyConfig.getScaleTimeout());
        Assertions.assertEquals((int)20000, (int)emptyConfig.getLoggingInterval());
        Assertions.assertEquals((long)5000L, (long)emptyConfig.getWebsocketTimeout());
        Assertions.assertEquals((long)30000L, (long)emptyConfig.getWebsocketPingInterval());
        Assertions.assertEquals((int)10000, (int)emptyConfig.getUploadConnectionTimeout());
        Assertions.assertEquals((int)120000, (int)emptyConfig.getUploadRequestTimeout());
        Assertions.assertTrue((boolean)emptyConfig.getImpersonateExtras().isEmpty());
        Assertions.assertEquals((int)0, (int)emptyConfig.getImpersonateGroups().length);
        Assertions.assertFalse((boolean)emptyConfig.isHttp2Disable());
        Assertions.assertEquals((int)1, (int)emptyConfig.getTlsVersions().length);
        Assertions.assertTrue((boolean)emptyConfig.getErrorMessages().isEmpty());
    }

    private void assertConfig(Config config) {
        Assertions.assertNotNull((Object)config);
        Assertions.assertTrue((boolean)config.isTrustCerts());
        Assertions.assertTrue((boolean)config.isDisableHostnameVerification());
        Assertions.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assertions.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assertions.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assertions.assertEquals((Object)"user", (Object)config.getUsername());
        Assertions.assertEquals((Object)"pass", (Object)config.getPassword());
        Assertions.assertEquals((Object)"/path/to/cert", (Object)config.getCaCertFile());
        Assertions.assertEquals((Object)"cacertdata", (Object)config.getCaCertData());
        Assertions.assertEquals((Object)"/path/to/clientcert", (Object)config.getClientCertFile());
        Assertions.assertEquals((Object)"clientcertdata", (Object)config.getClientCertData());
        Assertions.assertEquals((Object)"/path/to/clientkey", (Object)config.getClientKeyFile());
        Assertions.assertEquals((Object)"clientkeydata", (Object)config.getClientKeyData());
        Assertions.assertEquals((Object)"algo", (Object)config.getClientKeyAlgo());
        Assertions.assertEquals((Object)"passphrase", (Object)config.getClientKeyPassphrase());
        Assertions.assertEquals((Object)"httpProxy", (Object)config.getHttpProxy());
        Assertions.assertEquals((int)5000, (int)config.getWatchReconnectInterval());
        Assertions.assertEquals((int)5, (int)config.getWatchReconnectLimit());
        Assertions.assertEquals((int)5000, (int)config.getRequestTimeout());
        Assertions.assertEquals((int)60000, (int)config.getRequestConfig().getUploadConnectionTimeout());
        Assertions.assertEquals((int)600000, (int)config.getRequestConfig().getUploadRequestTimeout());
        Assertions.assertArrayEquals((Object[])new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1}, (Object[])config.getTlsVersions());
        Assertions.assertEquals((Object)"/path/to/truststore", (Object)config.getTrustStoreFile());
        Assertions.assertEquals((Object)"truststorePassphrase", (Object)config.getTrustStorePassphrase());
        Assertions.assertEquals((Object)"/path/to/keystore", (Object)config.getKeyStoreFile());
        Assertions.assertEquals((Object)"keystorePassphrase", (Object)config.getKeyStorePassphrase());
        Assertions.assertEquals((int)120, (int)config.getMaxConcurrentRequests());
        Assertions.assertEquals((int)20, (int)config.getMaxConcurrentRequestsPerHost());
    }

    @Test
    void testGetAuthenticatorCommandFromExecConfig() throws IOException {
        File commandFolder = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        File commandFile = new File(commandFolder, "aws");
        boolean isNewFileCreated = commandFile.createNewFile();
        String systemPathValue = this.getTestPathValue(commandFolder);
        ExecConfig execConfig = ((ExecConfigBuilder)((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().withApiVersion("client.authentication.k8s.io/v1alpha1")).addToArgs(new String[]{"--region", "us-west2", "eks", "get-token", "--cluster-name", "api-eks.example.com"})).withCommand("aws")).build();
        List processBuilderArgs = Config.getAuthenticatorCommandFromExecConfig((ExecConfig)execConfig, (File)new File("~/.kube/config"), (String)systemPathValue);
        Assertions.assertTrue((boolean)isNewFileCreated);
        Assertions.assertNotNull((Object)processBuilderArgs);
        Assertions.assertEquals((int)3, (int)processBuilderArgs.size());
        this.assertPlatformPrefixes(processBuilderArgs);
        List<String> commandParts = Arrays.asList(((String)processBuilderArgs.get(2)).split(" "));
        Assertions.assertEquals((Object)commandFile.getAbsolutePath(), (Object)commandParts.get(0));
        Assertions.assertEquals((Object)"--region", (Object)commandParts.get(1));
        Assertions.assertEquals((Object)"us-west2", (Object)commandParts.get(2));
        Assertions.assertEquals((Object)"eks", (Object)commandParts.get(3));
        Assertions.assertEquals((Object)"get-token", (Object)commandParts.get(4));
        Assertions.assertEquals((Object)"--cluster-name", (Object)commandParts.get(5));
        Assertions.assertEquals((Object)"api-eks.example.com", (Object)commandParts.get(6));
    }

    @Test
    void testGetAuthenticatorCommandFromExecConfigNullArgs() throws IOException {
        File commandFolder = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        File commandFile = new File(commandFolder, "gke-gcloud-auth-plugin");
        String systemPathValue = this.getTestPathValue(commandFolder);
        ExecConfig execConfigNoArgs = ((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().withApiVersion("client.authentication.k8s.io/v1alpha1")).withCommand(commandFile.getPath())).build();
        execConfigNoArgs.setArgs(null);
        List processBuilderArgs = Config.getAuthenticatorCommandFromExecConfig((ExecConfig)execConfigNoArgs, null, (String)systemPathValue);
        Assertions.assertNotNull((Object)processBuilderArgs);
        Assertions.assertEquals((int)3, (int)processBuilderArgs.size());
        this.assertPlatformPrefixes(processBuilderArgs);
        Assertions.assertEquals((Object)commandFile.getPath(), processBuilderArgs.get(2));
    }

    private void assertPlatformPrefixes(List<String> processBuilderArgs) {
        List platformArgsExpected = Utils.getCommandPlatformPrefix();
        Assertions.assertEquals(platformArgsExpected.get(0), (Object)processBuilderArgs.get(0));
        Assertions.assertEquals(platformArgsExpected.get(1), (Object)processBuilderArgs.get(1));
    }

    private String getTestPathValue(File commandFolder) {
        if (Utils.isWindowsOperatingSystem()) {
            return "C:\\Program Files\\Java\\jdk14.0_23\\bin" + File.pathSeparator + commandFolder.getAbsolutePath() + File.pathSeparator + "C:\\Program Files\\Apache Software Foundation\\apache-maven-3.3.1";
        }
        return "/usr/java/jdk-14.0.1/bin" + File.pathSeparator + commandFolder.getAbsolutePath() + File.pathSeparator + "/opt/apache-maven/bin";
    }
}

