/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.utils.serialization.UnmatchedFieldTypeModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnmatchedFieldTypeModuleTest {
    private ObjectMapper objectMapper;
    private UnmatchedFieldTypeModule unmatchedFieldTypeModule;

    UnmatchedFieldTypeModuleTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectMapper = new ObjectMapper();
        this.unmatchedFieldTypeModule = new UnmatchedFieldTypeModule(false, false);
        this.objectMapper.registerModule((Module)this.unmatchedFieldTypeModule);
    }

    @Test
    @DisplayName(value="readValue, with unknown fields, values are set in additionalProperties map")
    void readValueWithUnknownFields() throws JsonProcessingException {
        String json = "{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\"}";
        KubernetesResource result = (KubernetesResource)this.objectMapper.readValue("{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\"}", KubernetesResource.class);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(ConfigMap.class)).hasFieldOrPropertyWithValue("metadata.name", (Object)"the-name")).hasFieldOrPropertyWithValue("data.key", (Object)"value")).hasFieldOrPropertyWithValue("additionalProperties.unknownField", (Object)"unknownValue");
    }

    @Test
    @DisplayName(value="readValue, with unmatched type fields, values are set in additionalProperties map")
    void readValueWithUnmatchedTypeFields() throws JsonProcessingException {
        String json = "{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\",\"immutable\":\"${immutable}\"}";
        KubernetesResource result = (KubernetesResource)this.objectMapper.readValue("{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\",\"immutable\":\"${immutable}\"}", KubernetesResource.class);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(ConfigMap.class)).hasFieldOrPropertyWithValue("metadata.name", (Object)"the-name")).hasFieldOrPropertyWithValue("immutable", null)).hasFieldOrPropertyWithValue("additionalProperties.unknownField", (Object)"unknownValue")).hasFieldOrPropertyWithValue("additionalProperties.immutable", (Object)"${immutable}");
    }

    @Test
    @DisplayName(value="readValue, with unmatched type nested fields, values are set in additionalProperties map")
    void readValueWithUnmatchedTypeNestedFields() throws JsonProcessingException {
        String json = "{\"kind\": \"Deployment\",\"apiVersion\": \"apps/v1\",\"metadata\":{\"name\":\"deployment\", \"annotations\": \"${annotations}\"},\"spec\":{\"replicas\":\"${replicas}\",\"paused\":true},\"unknownField\":\"unknownValue\"}";
        KubernetesResource result = (KubernetesResource)this.objectMapper.readValue("{\"kind\": \"Deployment\",\"apiVersion\": \"apps/v1\",\"metadata\":{\"name\":\"deployment\", \"annotations\": \"${annotations}\"},\"spec\":{\"replicas\":\"${replicas}\",\"paused\":true},\"unknownField\":\"unknownValue\"}", KubernetesResource.class);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(Deployment.class)).hasFieldOrPropertyWithValue("metadata.name", (Object)"deployment")).hasFieldOrPropertyWithValue("metadata.annotations", null)).hasFieldOrPropertyWithValue("metadata.additionalProperties.annotations", (Object)"${annotations}")).hasFieldOrPropertyWithValue("spec.paused", (Object)true)).hasFieldOrPropertyWithValue("spec.replicas", null)).hasFieldOrPropertyWithValue("spec.additionalProperties.replicas", (Object)"${replicas}")).hasFieldOrPropertyWithValue("additionalProperties.unknownField", (Object)"unknownValue");
    }

    @Test
    @DisplayName(value="readValue, with no anySetter, should throw Exception")
    void readValueWithNoAnySetterShouldThrowException() {
        String json = "{\"value\": false}";
        MismatchedInputException result = (MismatchedInputException)org.junit.jupiter.api.Assertions.assertThrows(MismatchedInputException.class, () -> {
            Example cfr_ignored_0 = (Example)this.objectMapper.readValue("{\"value\": false}", Example.class);
        });
        Assertions.assertThat((Throwable)result).hasMessageStartingWith("Cannot deserialize value of type `int` from Boolean value");
    }

    @Test
    @DisplayName(value="readValue, with restrict to templates and unmatched type,  should throw Exception")
    void readValueWithRestrictToTemplatesAndUnmatchedTypeFields() {
        this.unmatchedFieldTypeModule.setRestrictToTemplates(true);
        String json = "{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"immutable\":\"${immutable}\"}";
        MismatchedInputException result = (MismatchedInputException)org.junit.jupiter.api.Assertions.assertThrows(MismatchedInputException.class, () -> {
            KubernetesResource cfr_ignored_0 = (KubernetesResource)this.objectMapper.readValue("{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"immutable\":\"${immutable}\"}", KubernetesResource.class);
        });
        Assertions.assertThat((Throwable)result).hasMessageStartingWith("Cannot deserialize value of type `java.lang.Boolean` from String");
    }

    @Test
    @DisplayName(value="writeValueAsString, with additionalProperties overriding fields, additionalProperties are serialized and fields ignored")
    void writeValueAsStringWithAdditionalPropertiesOverridingFields() throws JsonProcessingException {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("name")).addToAnnotations("key", "ignored")).addToLabels("lKey", "value")).endMetadata()).withImmutable(Boolean.valueOf(true))).build();
        configMap.getAdditionalProperties().put("immutable", "${immutable}");
        configMap.getAdditionalProperties().put("unknownField", "unknownValue");
        configMap.getMetadata().getAdditionalProperties().put("annotations", "${annotations}");
        String result = this.objectMapper.writeValueAsString((Object)configMap);
        Assertions.assertThat((String)result).isEqualTo("{\"apiVersion\":\"v1\",\"kind\":\"ConfigMap\",\"metadata\":{\"labels\":{\"lKey\":\"value\"},\"name\":\"name\",\"annotations\":\"${annotations}\"},\"immutable\":\"${immutable}\",\"unknownField\":\"unknownValue\"}");
    }

    @Test
    @DisplayName(value="writeValueAsString, with additionalProperties overriding fields and enabled log, should log warning")
    void writeValueAsStringWithAdditionalPropertiesOverridingFieldsShouldLogWarning() throws JsonProcessingException {
        try (MockedStatic lfMock = Mockito.mockStatic(LoggerFactory.class);){
            this.unmatchedFieldTypeModule.setLogWarnings(true);
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("name")).endMetadata()).withImmutable(Boolean.valueOf(true))).build();
            configMap.getAdditionalProperties().put("immutable", "I'll trigger a warning");
            Logger mockLogger = (Logger)Mockito.mock(Logger.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            lfMock.when(() -> LoggerFactory.getLogger((Class)((Class)ArgumentMatchers.any(Class.class)))).thenReturn((Object)mockLogger);
            this.objectMapper.writeValueAsString((Object)configMap);
            ((Logger)Mockito.verify((Object)mockLogger, (VerificationMode)Mockito.times((int)1))).warn("Value in field '{}' ignored in favor of value in additionalProperties ({}) for {}", new Object[]{"immutable", "I'll trigger a warning", "io.fabric8.kubernetes.api.model.ConfigMap"});
        }
    }

    @Test
    @DisplayName(value="writeValueAsString, with additionalProperties overriding fields and disabled log, should NOT log warning")
    void writeValueAsStringWithAdditionalPropertiesOverridingFieldsShouldNotLogWarning() throws JsonProcessingException {
        try (MockedStatic lfMock = Mockito.mockStatic(LoggerFactory.class);){
            ObjectMapper om = new ObjectMapper();
            UnmatchedFieldTypeModule module = new UnmatchedFieldTypeModule();
            om.registerModule((Module)module);
            module.setLogWarnings(false);
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("name")).endMetadata()).withImmutable(Boolean.valueOf(true))).build();
            configMap.getAdditionalProperties().put("immutable", "I'll trigger a warning");
            Logger mockLogger = (Logger)Mockito.mock(Logger.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            lfMock.when(() -> LoggerFactory.getLogger((Class)((Class)ArgumentMatchers.any(Class.class)))).thenReturn((Object)mockLogger);
            om.writeValueAsString((Object)configMap);
            ((Logger)Mockito.verify((Object)mockLogger, (VerificationMode)Mockito.never())).warn("Value in field '{}' ignored in favor of value in additionalProperties ({}) for {}", new Object[]{"immutable", "I'll trigger a warning", "io.fabric8.kubernetes.api.model.ConfigMap"});
        }
    }

    private static class Example {
        public int value;

        private Example() {
        }
    }
}

