/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.readiness;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReadinessTest {
    private Readiness readiness;

    ReadinessTest() {
    }

    @BeforeEach
    void setUp() {
        this.readiness = Readiness.getInstance();
    }

    @Test
    void testStatefulSetReadinessNoSpecNoStatus() {
        StatefulSet statefulSet = new StatefulSet();
        Assertions.assertFalse((boolean)this.readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    void testStatefulSetReadinessNoSpec() {
        StatefulSetStatus status = new StatefulSetStatus();
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setStatus(status);
        Assertions.assertFalse((boolean)this.readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
        status.setReadyReplicas(Integer.valueOf(1));
        Assertions.assertFalse((boolean)this.readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    void testStatefulSetReadinessNoStatus() {
        StatefulSetSpec spec = new StatefulSetSpec();
        spec.setReplicas(Integer.valueOf(1));
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setSpec(spec);
        Assertions.assertFalse((boolean)this.readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    void testStatefulSetReadinessNotEnoughReadyReplicas() {
        StatefulSetStatus status = new StatefulSetStatus();
        status.setReadyReplicas(Integer.valueOf(1));
        status.setReplicas(Integer.valueOf(2));
        StatefulSetSpec spec = new StatefulSetSpec();
        spec.setReplicas(Integer.valueOf(2));
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setStatus(status);
        statefulSet.setSpec(spec);
        Assertions.assertFalse((boolean)this.readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    void testStatefulSetReadiness() {
        StatefulSetStatus status = new StatefulSetStatus();
        status.setReadyReplicas(Integer.valueOf(2));
        status.setReplicas(Integer.valueOf(2));
        StatefulSetSpec spec = new StatefulSetSpec();
        spec.setReplicas(Integer.valueOf(2));
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setStatus(status);
        statefulSet.setSpec(spec);
        Assertions.assertTrue((boolean)this.readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertTrue((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    void testReadinessWithNonNullResource() {
        Assertions.assertTrue((boolean)this.readiness.isReady((HasMetadata)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).build()));
    }

    @Test
    void testReadinessNullResource() {
        Assertions.assertFalse((boolean)this.readiness.isReady(null));
    }
}

