/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUploadWebSocketListener;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodUploadTest {
    private HttpClient mockClient;
    private PodOperationContext mockContext;
    private OperationSupport operationSupport;
    private Path mockPathToUpload;
    private WebSocket mockWebSocket;

    PodUploadTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockContext = (PodOperationContext)Mockito.mock(PodOperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.operationSupport = (OperationSupport)Mockito.mock(OperationSupport.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockPathToUpload = (Path)Mockito.mock(Path.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockWebSocket = (WebSocket)Mockito.mock(WebSocket.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockClient.newBuilder().readTimeout(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class))).build()).thenReturn((Object)this.mockClient);
        Mockito.when((Object)this.operationSupport.getResourceUrl()).thenReturn((Object)new URL("https://openshift.com:8443/api/v1/namespaces/default/pods/mock-pod/"));
    }

    @AfterEach
    void tearDown() {
        this.mockClient = null;
        this.mockContext = null;
        this.operationSupport = null;
        this.mockPathToUpload = null;
    }

    @Test
    void testUploadInvalidParametersShouldThrowException() {
        IllegalArgumentException result = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PodUpload.upload((HttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (Path)this.mockPathToUpload));
        MatcherAssert.assertThat((Object)result.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Provided arguments are not valid (file, directory, path)"));
    }

    @Test
    void upload_whenFilePathProvided_shouldUploadFile() throws IOException, InterruptedException {
        Mockito.when((Object)this.mockPathToUpload.toFile()).thenReturn((Object)new File(PodUpload.class.getResource("/upload/upload-sample.txt").getFile()));
        this.uploadFileAndVerify(() -> PodUpload.upload((HttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (Path)this.mockPathToUpload));
        ((Path)Mockito.verify((Object)this.mockPathToUpload, (VerificationMode)Mockito.atLeast((int)1))).toFile();
    }

    @Test
    void uploadFileData_whenByteArrayInputStreamProvided_shouldUploadFile() throws IOException, InterruptedException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test data".getBytes());
        this.uploadFileAndVerify(() -> PodUpload.uploadFileData((HttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (InputStream)inputStream));
    }

    @Test
    void testUploadDirectoryHappyScenarioShouldUploadDirectory() throws Exception {
        this.uploadDirectoryAndVerify("/upload");
    }

    @Test
    void testUploadDirectoryLongFileNameShouldUploadDirectory() throws Exception {
        this.uploadDirectoryAndVerify("/upload_long");
    }

    private void uploadDirectoryAndVerify(String resourcePath) throws IOException, InterruptedException {
        Mockito.when((Object)this.mockContext.getDir()).thenReturn((Object)"/mock/dir");
        Mockito.when((Object)this.mockPathToUpload.toFile()).thenReturn((Object)new File(PodUpload.class.getResource(resourcePath).getFile()));
        WebSocket.Builder builder = (WebSocket.Builder)Mockito.mock(WebSocket.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)builder.buildAsync((WebSocket.Listener)ArgumentMatchers.any())).thenAnswer(newWebSocket -> {
            PodUploadWebSocketListener wsl = (PodUploadWebSocketListener)newWebSocket.getArgument(0, PodUploadWebSocketListener.class);
            wsl.onOpen(this.mockWebSocket);
            wsl.onMessage(this.mockWebSocket, ByteBuffer.wrap(new byte[]{0}));
            ((WebSocket)Mockito.doAnswer(close -> {
                wsl.onClose(this.mockWebSocket, ((Integer)close.getArgument(0)).intValue(), (String)close.getArgument(1));
                return null;
            }).when((Object)this.mockWebSocket)).sendClose(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
            return CompletableFuture.completedFuture(this.mockWebSocket);
        });
        Mockito.when((Object)this.mockClient.newWebSocketBuilder()).thenReturn((Object)builder);
        boolean result = PodUpload.upload((HttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (Path)this.mockPathToUpload);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        ((Path)Mockito.verify((Object)this.mockPathToUpload, (VerificationMode)Mockito.atLeast((int)1))).toFile();
        ((WebSocket.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.times((int)1))).uri((URI)ArgumentMatchers.argThat(request -> {
            MatcherAssert.assertThat((Object)request.toString(), (Matcher)CoreMatchers.equalTo((Object)"https://openshift.com:8443/api/v1/namespaces/default/pods/mock-pod/exec?command=sh&command=-c&command=mkdir+-p+%27%2Fmock%2Fdir%27+%26%26+base64+-d+-+%7C+tar+-C+%27%2Fmock%2Fdir%27+-xzf+-&stdin=true&stderr=true"));
            return true;
        }));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.atLeast((int)1))).send((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    void testCopy() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("I'LL BE COPIED".getBytes(Charset.defaultCharset()));
        ObjIntConsumer<byte[]> consumer = (bytes, length) -> {
            MatcherAssert.assertThat((Object)length, (Matcher)CoreMatchers.equalTo((Object)14));
            MatcherAssert.assertThat((Object)new String(Arrays.copyOf(bytes, 14), Charset.defaultCharset()), (Matcher)CoreMatchers.equalTo((Object)"I'LL BE COPIED"));
        };
        PodUpload.copy((InputStream)input, consumer);
    }

    @Test
    void createExecCommandForUpload_withFileInRootPath_shouldCreateValidExecCommandForUpload() {
        Mockito.when((Object)this.mockContext.getFile()).thenReturn((Object)"/cp.log");
        String result = PodUpload.createExecCommandForUpload((PodOperationContext)this.mockContext);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)"mkdir -p '/' && base64 -d - > '/cp.log'"));
    }

    @Test
    void createExecCommandForUpload_withNormalFile_shouldCreateValidExecCommandForUpload() {
        Mockito.when((Object)this.mockContext.getFile()).thenReturn((Object)"/tmp/foo/cp.log");
        String result = PodUpload.createExecCommandForUpload((PodOperationContext)this.mockContext);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)"mkdir -p '/tmp/foo' && base64 -d - > '/tmp/foo/cp.log'"));
    }

    void uploadFileAndVerify(PodUploadTester<Boolean> fileUploadMethodToTest) throws IOException, InterruptedException {
        Mockito.when((Object)this.mockContext.getFile()).thenReturn((Object)"/mock/dir/file");
        WebSocket.Builder builder = (WebSocket.Builder)Mockito.mock(WebSocket.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)builder.buildAsync((WebSocket.Listener)ArgumentMatchers.any())).thenAnswer(newWebSocket -> {
            PodUploadWebSocketListener wsl = (PodUploadWebSocketListener)newWebSocket.getArgument(0, PodUploadWebSocketListener.class);
            wsl.onOpen(this.mockWebSocket);
            wsl.onMessage(this.mockWebSocket, ByteBuffer.wrap(new byte[]{0}));
            ((WebSocket)Mockito.doAnswer(close -> {
                wsl.onClose(this.mockWebSocket, ((Integer)close.getArgument(0)).intValue(), (String)close.getArgument(1));
                return null;
            }).when((Object)this.mockWebSocket)).sendClose(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
            return CompletableFuture.completedFuture(this.mockWebSocket);
        });
        Mockito.when((Object)this.mockClient.newWebSocketBuilder()).thenReturn((Object)builder);
        boolean result = fileUploadMethodToTest.apply();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        ((WebSocket.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.times((int)1))).uri((URI)ArgumentMatchers.argThat(request -> {
            MatcherAssert.assertThat((Object)request.toString(), (Matcher)CoreMatchers.equalTo((Object)"https://openshift.com:8443/api/v1/namespaces/default/pods/mock-pod/exec?command=sh&command=-c&command=mkdir+-p+%27%2Fmock%2Fdir%27+%26%26+base64+-d+-+%3E+%27%2Fmock%2Fdir%2Ffile%27&stdin=true&stderr=true"));
            return true;
        }));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.atLeast((int)1))).send((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @FunctionalInterface
    public static interface PodUploadTester<R> {
        public R apply() throws IOException, InterruptedException;
    }
}

