/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class OkHttpClientFactoryTest {
    OkHttpClientFactoryTest() {
    }

    @Test
    void shouldRespectMaxRequests() {
        OkHttpClientImpl client = new OkHttpClientFactory().createHttpClient(new ConfigBuilder().build());
        Assertions.assertEquals((int)64, (int)client.getOkHttpClient().dispatcher().getMaxRequests());
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequests(120)).build();
        client = new OkHttpClientFactory().createHttpClient(config);
        Assertions.assertEquals((int)120, (int)client.getOkHttpClient().dispatcher().getMaxRequests());
    }

    @Test
    void shouldRespectMaxRequestsPerHost() {
        OkHttpClientImpl client = new OkHttpClientFactory().createHttpClient(new ConfigBuilder().build());
        Assertions.assertEquals((int)5, (int)client.getOkHttpClient().dispatcher().getMaxRequestsPerHost());
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequestsPerHost(20)).build();
        client = new OkHttpClientFactory().createHttpClient(config);
        Assertions.assertEquals((int)20, (int)client.getOkHttpClient().dispatcher().getMaxRequestsPerHost());
    }

    @Test
    void inteceptorClosure() throws IOException {
        OkHttpClientBuilderImpl.InteceptorAdapter adapter = new OkHttpClientBuilderImpl.InteceptorAdapter(new Interceptor(){

            public boolean afterFailure(BasicBuilder builder, HttpResponse<?> response) {
                return true;
            }
        }, "name");
        Interceptor.Chain chain = (Interceptor.Chain)Mockito.mock(Interceptor.Chain.class);
        Mockito.when((Object)chain.request()).thenReturn(Mockito.mock(Request.class));
        Mockito.when((Object)chain.request().newBuilder()).thenReturn(Mockito.mock(Request.Builder.class));
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)chain.proceed((Request)Mockito.any())).thenReturn((Object)response);
        adapter.intercept(chain);
        ((Response)Mockito.verify((Object)response)).close();
    }
}

