/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.client.informers.cache.ProcessorStore;
import io.fabric8.kubernetes.client.informers.cache.SharedProcessor;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProcessorStoreTest {
    @Test
    public void testEvents() {
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ProcessorListener.Notification.class);
        ArgumentCaptor syncCaptor = ArgumentCaptor.forClass(Boolean.class);
        Cache podCache = (Cache)Mockito.mock(Cache.class);
        SharedProcessor processor = (SharedProcessor)Mockito.mock(SharedProcessor.class);
        ProcessorStore processorStore = new ProcessorStore(podCache, processor);
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod")).endMetadata()).build();
        processorStore.add((HasMetadata)pod);
        processorStore.update((HasMetadata)pod);
        processorStore.delete((HasMetadata)pod);
        Mockito.when((Object)podCache.put((Object)pod)).thenReturn((Object)pod);
        processorStore.update((HasMetadata)pod);
        Mockito.when((Object)podCache.remove((Object)pod)).thenReturn((Object)pod);
        processorStore.delete((HasMetadata)pod);
        ((SharedProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)4))).distribute((ProcessorListener.Notification)notificationCaptor.capture(), ((Boolean)syncCaptor.capture()).booleanValue());
        List notifications = notificationCaptor.getAllValues();
        Assertions.assertThat(notifications.get(0)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(1)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(2)).isInstanceOf(ProcessorListener.UpdateNotification.class);
        Assertions.assertThat(notifications.get(3)).isInstanceOf(ProcessorListener.DeleteNotification.class);
        List syncValues = syncCaptor.getAllValues();
        Assertions.assertThat((Boolean)((Boolean)syncValues.get(0))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)syncValues.get(1))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)syncValues.get(2))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)syncValues.get(3))).isFalse();
    }

    @Test
    public void testSyncEvents() {
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ProcessorListener.Notification.class);
        ArgumentCaptor syncCaptor = ArgumentCaptor.forClass(Boolean.class);
        Cache podCache = new Cache();
        SharedProcessor processor = (SharedProcessor)Mockito.mock(SharedProcessor.class);
        ProcessorStore processorStore = new ProcessorStore(podCache, processor);
        Pod pod = ((PodBuilder)new PodBuilder().withNewMetadata().endMetadata()).build();
        Pod pod2 = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).endMetadata()).build();
        processorStore.add((HasMetadata)pod);
        processorStore.add((HasMetadata)pod2);
        processorStore.resync();
        processorStore.retainAll(Collections.emptySet());
        ((SharedProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)6))).distribute((ProcessorListener.Notification)notificationCaptor.capture(), ((Boolean)syncCaptor.capture()).booleanValue());
        List notifications = notificationCaptor.getAllValues();
        Assertions.assertThat(notifications.get(0)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(1)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(2)).isInstanceOf(ProcessorListener.UpdateNotification.class);
        Assertions.assertThat(notifications.get(3)).isInstanceOf(ProcessorListener.UpdateNotification.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncCaptor.getAllValues().subList(0, 2).stream().allMatch(s -> s == false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncCaptor.getAllValues().subList(2, 4).stream().allMatch(s -> s));
        Assertions.assertThat(notifications.get(4)).isInstanceOf(ProcessorListener.DeleteNotification.class);
        Assertions.assertThat(notifications.get(5)).isInstanceOf(ProcessorListener.DeleteNotification.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncCaptor.getAllValues().subList(4, 6).stream().allMatch(s -> s == false));
    }
}

