/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.dsl.internal.PortForwarderWebsocket;
import io.fabric8.kubernetes.client.http.HttpClient;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class PortForwarderWebsocketTest {
    private final HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private PortForwarderWebsocket portForwarderWebsocket;

    PortForwarderWebsocketTest() {
    }

    @BeforeEach
    void initPortForwarderWebsocket() {
        this.portForwarderWebsocket = new PortForwarderWebsocket(this.mockHttpClient);
    }

    @Test
    void testCreateNewInetSocketAddressWithNullLocalhost() {
        int port = 8080;
        InetSocketAddress inetSocketAddress = this.portForwarderWebsocket.createNewInetSocketAddress(null, 8080);
        AssertionsForClassTypes.assertThat((boolean)inetSocketAddress.getAddress().isAnyLocalAddress()).isTrue();
        AssertionsForClassTypes.assertThat((int)inetSocketAddress.getPort()).isEqualTo(port);
    }

    @Test
    void testCreateNewInetSocketAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByAddress(new byte[]{10, 19, 21, 23});
        int port = 8080;
        InetSocketAddress inetSocketAddress = this.portForwarderWebsocket.createNewInetSocketAddress(inetAddress, 8080);
        AssertionsForClassTypes.assertThat((Object)inetSocketAddress.getAddress()).isEqualTo((Object)inetAddress);
        AssertionsForClassTypes.assertThat((int)inetSocketAddress.getPort()).isEqualTo(port);
    }
}

