/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class AbstractWatchManagerTest {
    AbstractWatchManagerTest() {
    }

    @Test
    @DisplayName(value="closeEvent, is idempotent, multiple calls only close watcher once")
    void closeEventIsIdempotent() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.closeEvent();
        }
        Assertions.assertThat((int)watcher.closeCount.get()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="closeEvent, with Exception, is idempotent, multiple calls only close watcher once")
    void closeEventWithExceptionIsIdempotent() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.close(new WatcherException("Mock"));
        }
        Assertions.assertThat((int)watcher.closeCount.get()).isEqualTo(1);
    }

    @Test
    void closeEventWithExceptionIsIdempotentWithReconnecting() throws MalformedURLException {
        WatcherAdapter<HasMetadata> watcher = new WatcherAdapter<HasMetadata>(){

            public boolean reconnecting() {
                return true;
            }
        };
        WatchManager<HasMetadata> awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.close(new WatcherException("Mock"));
        }
        Assertions.assertThat((int)((WatcherAdapter)watcher).closeCount.get()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="closeWebSocket, closes web socket with 1000 code (Normal Closure)")
    void closeWebSocket() {
        WebSocket webSocket = (WebSocket)Mockito.mock(WebSocket.class);
        WatchConnectionManager.closeWebSocket((WebSocket)webSocket);
        ((WebSocket)Mockito.verify((Object)webSocket, (VerificationMode)Mockito.times((int)1))).sendClose(1000, null);
    }

    @Test
    @DisplayName(value="nextReconnectInterval, returns exponential interval values up to the provided limit")
    void nextReconnectInterval() throws MalformedURLException {
        WatchManager awm = new WatchManager(null, (ListOptions)Mockito.mock(ListOptions.class), 0, 10, 5);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(10L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(20L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(40L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(80L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(160L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(320L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(320L);
    }

    @Test
    @DisplayName(value="cancelReconnect, with null attempt, should do nothing")
    void cancelReconnectNullAttempt() throws MalformedURLException {
        ScheduledFuture sf = (ScheduledFuture)Mockito.spy(ScheduledFuture.class);
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.cancelReconnect();
        ((ScheduledFuture)Mockito.verify((Object)sf, (VerificationMode)Mockito.times((int)0))).cancel(true);
    }

    @Test
    @DisplayName(value="cancelReconnect, with non-null attempt, should cancel")
    void cancelReconnectNonNullAttempt() throws MalformedURLException {
        ScheduledFuture sf = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        MockedStatic utils = Mockito.mockStatic(Utils.class);
        utils.when(() -> Utils.schedule((Executor)((Executor)ArgumentMatchers.any()), (Runnable)((Runnable)ArgumentMatchers.any()), (long)ArgumentMatchers.anyLong(), (TimeUnit)((TimeUnit)((Object)((Object)ArgumentMatchers.any()))))).thenReturn((Object)sf);
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.scheduleReconnect();
        awm.cancelReconnect();
        ((ScheduledFuture)Mockito.verify((Object)sf, (VerificationMode)Mockito.times((int)1))).cancel(true);
    }

    @Test
    @DisplayName(value="isClosed, after close invocation, should return true")
    void isForceClosedWhenClosed() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.close();
        Assertions.assertThat((boolean)awm.isForceClosed()).isTrue();
    }

    @Test
    @DisplayName(value="close, after close invocation, should return true")
    void closeWithNonNullRunnerShouldCancelRunner() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.close();
        Assertions.assertThat((int)awm.closeCount.get()).isEqualTo(1);
    }

    private static <T extends HasMetadata> WatchManager<T> withDefaultWatchManager(Watcher<T> watcher) throws MalformedURLException {
        return new WatchManager<T>(watcher, (ListOptions)Mockito.mock(ListOptions.class, (Answer)Mockito.RETURNS_DEEP_STUBS), 1, 0, 0);
    }

    private static final class WatchManager<T extends HasMetadata>
    extends AbstractWatchManager<T> {
        private final AtomicInteger closeCount = new AtomicInteger(0);

        public WatchManager(Watcher<T> watcher, ListOptions listOptions, int reconnectLimit, int reconnectInterval, int maxIntervalExponent) throws MalformedURLException {
            super(watcher, (BaseOperation)Mockito.mock(BaseOperation.class), listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, () -> null);
        }

        protected void run(URL url, Map<String, String> headers) {
        }

        protected void closeRequest() {
            this.closeCount.addAndGet(1);
        }

        protected void runWatch() {
        }
    }

    private static class WatcherAdapter<T>
    implements Watcher<T> {
        private final AtomicInteger closeCount = new AtomicInteger(0);

        private WatcherAdapter() {
        }

        public void eventReceived(Watcher.Action action, T resource) {
        }

        public void onClose(WatcherException cause) {
            this.closeCount.addAndGet(1);
        }

        public void onClose() {
            this.closeCount.addAndGet(1);
        }
    }
}

