/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.MockHttpClientUtils;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PatchTest {
    private HttpClient mockClient;
    private KubernetesClient kubernetesClient;
    private List<HttpRequest.Builder> builders = new ArrayList<HttpRequest.Builder>();

    PatchTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.builders.clear();
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        HttpResponse<InputStream> mockResponse = MockHttpClientUtils.buildResponse(200, "{}");
        Mockito.when((Object)this.mockClient.send((HttpRequest)ArgumentMatchers.any(), (Class)Mockito.eq(InputStream.class))).thenReturn(mockResponse);
        this.kubernetesClient = new DefaultKubernetesClient(this.mockClient, config);
        Mockito.when((Object)this.mockClient.newHttpRequestBuilder()).thenAnswer(answer -> {
            HttpRequest.Builder result = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)request.uri()).thenReturn((Object)URI.create("https://localhost:8443/"));
            Mockito.when((Object)result.build()).thenReturn((Object)request);
            this.builders.add(result);
            return result;
        });
    }

    @Test
    void testJsonPatch() throws IOException {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/strategic-merge-patch+json");
    }

    @Test
    void testJsonMergePatch() throws IOException {
        PatchContext patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON_MERGE).build();
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(patchContext, "{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/merge-patch+json");
    }

    @Test
    void testYamlPatchConvertedToJson() throws IOException {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("metadata:\n  annotations:\n    bob: martin");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/strategic-merge-patch+json");
    }

    @Test
    void testPatchThrowExceptionWhenResourceNotFound() throws IOException {
        HttpResponse<InputStream> mockResponse = MockHttpClientUtils.buildResponse(404, "{}");
        Mockito.when((Object)this.mockClient.send((HttpRequest)ArgumentMatchers.any(), (Class)Mockito.eq(InputStream.class))).thenReturn(mockResponse);
        PodResource podResource = (PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo");
        KubernetesClientException e = (KubernetesClientException)Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod cfr_ignored_0 = (Pod)podResource.patch("{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        });
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        Assertions.assertEquals((int)404, (int)e.getCode());
    }

    @Test
    void testJsonPatchWithPositionalArrays() throws IOException {
        PatchContext patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(patchContext, "[{\"op\": \"replace\", \"path\":\"/spec/containers/0/image\", \"value\":\"foo/gb-frontend:v4\"}]");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/json-patch+json");
    }

    @Test
    void testPatchWithPatchOptions() throws IOException {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(new PatchContext.Builder().withFieldManager("fabric8").withDryRun(Collections.singletonList("All")).build(), "{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", "fieldManager=fabric8&dryRun=All", "application/strategic-merge-patch+json");
    }

    private void assertRequest(String method, String url, String queryParam) {
        this.assertRequest(0, method, url, queryParam, null);
    }

    private void assertRequest(int index, String method, String url, String queryParam, String contentType) {
        ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(URL.class);
        HttpRequest.Builder mock = this.builders.get(index);
        ((HttpRequest.Builder)Mockito.verify((Object)mock)).url((URL)urlCaptor.capture());
        URL capturedURL = (URL)urlCaptor.getValue();
        Assertions.assertEquals((Object)url, (Object)capturedURL.getPath());
        PatchTest.validateMethod(method, contentType, mock);
        Assertions.assertEquals((Object)queryParam, (Object)capturedURL.getQuery());
    }

    static void validateMethod(String method, String contentType, HttpRequest.Builder mock) {
        ArgumentCaptor contentTypeCaptor = ArgumentCaptor.forClass(String.class);
        switch (method) {
            case "DELETE": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).delete((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any());
                break;
            }
            case "POST": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).post((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any(String.class));
                break;
            }
            case "PUT": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).put((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any());
                break;
            }
            case "PATCH": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).patch((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any());
                break;
            }
        }
        if (contentType != null) {
            Assertions.assertEquals((Object)contentType, (Object)contentTypeCaptor.getValue());
        }
    }
}

