/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.HttpStatusMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockHttpClientUtils {
    public static HttpResponse<InputStream> buildResponse(int code, String body) {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)response.code()).thenReturn((Object)code);
        Mockito.when((Object)response.body()).thenReturn((Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
        HttpRequest mockRequest = MockHttpClientUtils.buildRequest();
        Mockito.when((Object)response.request()).thenReturn((Object)mockRequest);
        return response;
    }

    public static HttpRequest buildRequest() {
        HttpRequest mockRequest = (HttpRequest)Mockito.mock(HttpRequest.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockRequest.uri()).thenReturn((Object)URI.create("http://mock:8443"));
        return mockRequest;
    }

    public static HttpResponse<InputStream> buildResponse(int code) {
        return MockHttpClientUtils.buildResponse(code, "{\"kind\":\"Status\",\"status\":\"" + HttpStatusMessage.getMessageForStatus((int)code) + "\"}");
    }
}

