/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.MockHttpClientUtils;
import io.fabric8.kubernetes.client.PatchTest;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class DryRunTest {
    private HttpClient mockClient;
    private KubernetesClient kubernetesClient;
    private List<HttpRequest.Builder> builders = new ArrayList<HttpRequest.Builder>();

    DryRunTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.builders.clear();
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        HttpResponse<InputStream> mockResponse = MockHttpClientUtils.buildResponse(200, "{}");
        Mockito.when((Object)this.mockClient.send((HttpRequest)ArgumentMatchers.any(), (Class)Mockito.eq(InputStream.class))).thenReturn(mockResponse);
        this.kubernetesClient = new DefaultKubernetesClient(this.mockClient, config);
        Mockito.when((Object)this.mockClient.newHttpRequestBuilder()).thenAnswer(answer -> {
            HttpRequest.Builder result = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            this.builders.add(result);
            return result;
        });
    }

    @Test
    void testDryRunDisable() throws IOException {
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun(false)).create((Object)this.getPod("pod1"));
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("POST", "/api/v1/namespaces/ns1/pods", null);
        Assertions.assertNotNull((Object)pod);
    }

    @Test
    void testDryRunEnable() throws IOException {
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun(true)).create((Object)this.getPod("pod1"));
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
        Assertions.assertNotNull((Object)pod);
    }

    @Test
    void testCreate() throws IOException {
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun()).create((Object)this.getPod("pod1"));
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
        Assertions.assertNotNull((Object)pod);
    }

    @Test
    void testCreateOrReplace() throws IOException {
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun()).createOrReplace((Object[])new Pod[]{this.getPod("pod1")});
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        Assertions.assertNotNull((Object)pod);
        this.assertRequest("POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
    }

    @Test
    void testPatch() throws IOException {
        ((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("pod1")).dryRun()).patch((Object)this.getPod("pod1"));
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testReplace() throws IOException {
        ((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("pod1")).dryRun()).replace((Object)this.getPod("pod1"));
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest(1, "PUT", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testDelete() throws IOException {
        ((EditReplacePatchDeletable)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("pod1")).dryRun()).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("DELETE", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testResourceCreateOrReplace() throws IOException {
        ((VisitFromServerWritable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource((HasMetadata)this.getPod("pod1")).inNamespace("ns1")).dryRun()).createOrReplace();
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
    }

    @Test
    void testResourceDelete() throws IOException {
        ((CascadingDeletable)((VisitFromServerWritable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource((HasMetadata)this.getPod("pod1")).inNamespace("ns1")).dryRun()).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((HttpClient)Mockito.verify((Object)this.mockClient)).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("DELETE", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testResourceListCreateOrReplace() throws IOException {
        Pod pod = this.getPod("pod1");
        Service svc = ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).build();
        ((ListVisitFromServerWritable)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubernetesClient.resourceList(new HasMetadata[]{pod, svc}).inNamespace("ns1")).dryRun()).createOrReplace();
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("POST", "/api/v1/namespaces/ns1/services", "dryRun=All");
        this.assertRequest(1, "POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
    }

    @Test
    void testResourceListDelete() throws IOException {
        Pod pod = this.getPod("pod1");
        Service svc = ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).build();
        ((CascadingDeletable)((ListVisitFromServerWritable)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubernetesClient.resourceList(new HasMetadata[]{pod, svc}).inNamespace("ns1")).dryRun()).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).send((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("DELETE", "/api/v1/namespaces/ns1/services/svc1", "dryRun=All");
        this.assertRequest(1, "DELETE", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    private Pod getPod(String name) {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(name)).endMetadata()).build();
    }

    private void assertRequest(String method, String url, String queryParam) {
        this.assertRequest(0, method, url, queryParam);
    }

    private void assertRequest(int index, String method, String url, String queryParam) {
        ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(URL.class);
        HttpRequest.Builder mock = this.builders.get(index);
        ((HttpRequest.Builder)Mockito.verify((Object)mock)).url((URL)urlCaptor.capture());
        URL capturedURL = (URL)urlCaptor.getValue();
        Assertions.assertEquals((Object)url, (Object)capturedURL.getPath());
        PatchTest.validateMethod(method, null, mock);
        Assertions.assertEquals((Object)queryParam, (Object)capturedURL.getQuery());
    }
}

