/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupList;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.SimpleClientContext;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URL;
import java.util.List;

public class BaseClient
extends SimpleClientContext
implements Client {
    public static final String APIS = "/apis";
    private URL masterUrl;
    private String apiVersion;
    private String namespace;

    public BaseClient() {
        this(new ConfigBuilder().build());
    }

    public BaseClient(String masterUrl) {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public BaseClient(Config config) {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(HttpClient httpClient, Config config) {
        this(new SimpleClientContext(config, httpClient));
    }

    public BaseClient(ClientContext clientContext) {
        try {
            this.config = clientContext.getConfiguration();
            this.httpClient = clientContext.getHttpClient();
            this.adaptState();
            this.namespace = this.config.getNamespace();
            this.apiVersion = this.config.getApiVersion();
            if (this.config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(this.config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new OperationSupport(this.httpClient, this.config).restCall(RootPaths.class, new String[0]);
    }

    @Override
    public boolean supportsApiPath(String apiPath) {
        List paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public APIGroupList getApiGroups() {
        return new OperationSupport(this.httpClient, this.config).restCall(APIGroupList.class, APIS);
    }

    @Override
    public APIGroup getApiGroup(String name) {
        return new OperationSupport(this.httpClient, this.config).restCall(APIGroup.class, APIS, name);
    }

    @Override
    public APIResourceList getApiResources(String groupVersion) {
        return new OperationSupport(this.httpClient, this.config).restCall(APIResourceList.class, APIS, groupVersion);
    }

    protected VersionInfo getVersionInfo(String path) {
        return new OperationSupport(this.httpClient, this.getConfiguration()).restCall(VersionInfo.class, path);
    }

    protected void adaptState() {
    }

    protected SimpleClientContext newState(Config updated) {
        return new SimpleClientContext(updated, this.httpClient);
    }
}

