/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.MockHttpClientUtils;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TokenRefreshInterceptorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAutoconfigureAfter401() throws IOException {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-tokeninterceptor")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            boolean reissue = new TokenRefreshInterceptor(Config.autoConfigure(null), null).afterFailure(builder, MockHttpClientUtils.buildResponse(401, "foo"));
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer token");
            Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReloadInClusterServiceAccount() throws IOException {
        try {
            File tokenFile = Files.createTempFile("test", "token", new FileAttribute[0]).toFile();
            Files.write(tokenFile.toPath(), "expired".getBytes(), new OpenOption[0]);
            System.setProperty("kubernetes.auth.serviceAccount.token", tokenFile.getAbsolutePath());
            System.setProperty("kubernetes.auth.tryKubeConfig", "false");
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(Config.autoConfigure(null), null);
            Files.write(tokenFile.toPath(), "renewed".getBytes(), new OpenOption[0]);
            boolean reissue = interceptor.afterFailure(builder, MockHttpClientUtils.buildResponse(401, "foo"));
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer renewed");
            Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubernetes.auth.serviceAccount.token");
            System.clearProperty("kubernetes.auth.tryKubeConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldRefreshOIDCToken() throws IOException {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            Config config = Config.autoConfigure(null);
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-tokeninterceptor-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(config, (HttpClient.Factory)Mockito.mock(HttpClient.Factory.class));
            boolean reissue = interceptor.afterFailure(builder, MockHttpClientUtils.buildResponse(401, "foo"));
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer renewed");
            Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }
}

