/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class SerializationTest {
    SerializationTest() {
    }

    @Test
    void unmarshalCRDWithSchema() throws Exception {
        String input = this.readYamlToString("/test-crd-schema.yml");
        CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)input, CustomResourceDefinition.class);
        JSONSchemaProps spec = (JSONSchemaProps)crd.getSpec().getValidation().getOpenAPIV3Schema().getProperties().get("spec");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)spec).hasFieldOrPropertyWithValue("properties.builderName.example", (Object)new TextNode("builder-example"))).hasFieldOrPropertyWithValue("properties.hollow.default", (Object)BooleanNode.FALSE)).hasFieldOrPropertyWithValue("properties.dimensions.properties.x.default", (Object)new IntNode(10))).extracting(JSONSchemaProps::getRequired).asList().containsExactly(new Object[]{"builderName", "edges", "dimensions"});
    }

    @Test
    void asYamlWithDeserializedCRD() throws Exception {
        String input = this.readYamlToString("/test-crd-schema.yml");
        CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)input, CustomResourceDefinition.class);
        String result = Serialization.asYaml((Object)crd);
        Assertions.assertThat((String)result.trim()).isEqualTo(input.trim());
    }

    @Test
    @DisplayName(value="unmarshal, String containing List with windows like line-ends (CRLF), all list items should be available")
    void unmarshalListWithWindowsLineSeparatorsString() throws Exception {
        String crlfFile = this.readYamlToString("/test-list.yml");
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)crlfFile, KubernetesResource.class);
        ((AbstractListAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Object)result).asInstanceOf(InstanceOfAssertFactories.type(KubernetesList.class))).extracting(KubernetesList::getItems).asList().hasSize(2)).hasAtLeastOneElementOfType(Service.class)).hasAtLeastOneElementOfType(Deployment.class);
    }

    private String readYamlToString(String path) throws IOException {
        return Files.readAllLines(new File(SerializationTest.class.getResource(path).getFile()).toPath(), StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("#")).collect(Collectors.joining("\n"));
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with windows line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other");
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with windows line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with linux line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other");
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with linux line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void testSerializeYamlWithAlias() {
        InputStream fileInputStream = this.getClass().getResourceAsStream("/test-pod-manifest-with-aliases.yml");
        Pod pod = (Pod)Serialization.unmarshal((InputStream)fileInputStream);
        ((AbstractListAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pod).isNotNull()).hasFieldOrPropertyWithValue("metadata.name", (Object)"test-pod-with-alias")).hasFieldOrPropertyWithValue("spec.nodeSelector.workload", (Object)"build")).hasFieldOrPropertyWithValue("spec.tolerations.size", (Object)1)).hasFieldOrPropertyWithValue("spec.securityContext.runAsGroup", (Object)1000L)).hasFieldOrPropertyWithValue("spec.securityContext.runAsUser", (Object)1000L)).extracting(Pod::getSpec).extracting(PodSpec::getContainers).asList().hasSize(2)).extracting(new String[]{"name", "image", "resources.requests.cpu"}).containsExactly((Object[])new Tuple[]{new Tuple(new Object[]{"ubuntu", "ubuntu:bionic", new Quantity("100m")}), new Tuple(new Object[]{"python3", "python:3.7", new Quantity("100m")})});
    }

    @Test
    void testClone() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod")).endMetadata()).build();
        Pod clonePod = (Pod)Serialization.clone((Object)pod);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)clonePod).isEqualTo((Object)pod)).isNotSameAs((Object)pod)).hasFieldOrPropertyWithValue("metadata.name", (Object)"pod");
    }

    @Test
    @DisplayName(value="unmarshal, with valid YAML custom resource, should return GenericKubernetesResource instance")
    void unmarshalWithValidCustomResourceShouldReturnGenericCustomResource() {
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((InputStream)SerializationTest.class.getResourceAsStream("/serialization/custom-resource.yml"));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotNull()).isInstanceOf(GenericKubernetesResource.class)).hasFieldOrPropertyWithValue("apiVersion", (Object)"the-cr.example.com/v1")).hasFieldOrPropertyWithValue("Kind", (Object)"SomeCustomResource")).hasFieldOrPropertyWithValue("metadata.name", (Object)"custom-resource-example")).hasFieldOrPropertyWithValue("additionalProperties.spec.field", (Object)"value")).hasFieldOrPropertyWithValue("additionalProperties.status.reconciled", (Object)true);
    }

    @Test
    @DisplayName(value="unmarshal, with invalid YAML content, should throw Exception")
    void unmarshalWithInvalidYamlShouldThrowException() {
        InputStream is = SerializationTest.class.getResourceAsStream("/serialization/invalid-yaml.yml");
        ClassCastException result = (ClassCastException)org.junit.jupiter.api.Assertions.assertThrows(ClassCastException.class, () -> Serialization.unmarshal((InputStream)is));
        Assertions.assertThat((Throwable)result).hasMessageContainingAll(new CharSequence[]{"java.lang.String", "cannot be cast to", "java.util.Map"});
    }

    @Test
    @DisplayName(value="unmarshal, with invalid YAML resource, should return null")
    void unmarshalWithInvalidResourceShouldReturnNull() {
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((InputStream)SerializationTest.class.getResourceAsStream("/serialization/invalid-resource.yml"));
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    @DisplayName(value="unmarshal, with valid YAML list, should return KubernetesList")
    void unmarshalWithValidListShouldReturnKubernetesList() {
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((InputStream)SerializationTest.class.getResourceAsStream("/serialization/kubernetes-list.yml"));
        ((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Object)result).asInstanceOf(InstanceOfAssertFactories.type(KubernetesList.class))).extracting(KubernetesList::getItems).asList().hasSize(3)).extracting(new String[]{"class", "apiVersion", "kind", "metadata.name"}).containsExactlyInAnyOrder((Object[])new Tuple[]{new Tuple(new Object[]{GenericKubernetesResource.class, "custom.resource.example.com/v1", "Example", "a-custom-resource"}), new Tuple(new Object[]{Namespace.class, "v1", "Namespace", "a-namespace"}), new Tuple(new Object[]{Pod.class, "v1", "Pod", "a-pod"})});
    }

    @Test
    void testSerializeYamlWithJsonSubTypes() {
        Root root = new Root();
        root.setTypeable(new Typed());
        String result = Serialization.asYaml((Object)root);
        Assertions.assertThat((String)result).isEqualTo("---\ntypeable:\n  type: \"x\"\n", new Object[]{Serialization.asYaml((Object)root)});
    }

    @Test
    void nullValueShouldNotBeOutput() {
        MyCR cr = new MyCR();
        String s = Serialization.asYaml((Object)((Object)cr));
        ((AbstractStringAssert)Assertions.assertThat((String)s).doesNotContain(new CharSequence[]{"status"})).contains(new CharSequence[]{"spec: \"foo\""});
    }

    @Test
    void quantityQuoting() {
        Quantity quantity = (Quantity)Serialization.unmarshal((String)"amount: \"2\"\nformat: \"Gi\"", Quantity.class);
        Assertions.assertThat((String)Serialization.asYaml((Object)quantity)).isEqualTo("--- \"2Gi\"\n");
    }

    @Group(value="serialization.fabric8.io")
    @Version(value="v1")
    private static class MyCR
    extends CustomResource<String, Void> {
        public MyCR() {
            this.setSpec("foo");
        }
    }

    public static class Root {
        private Typeable typeable;

        public Typeable getTypeable() {
            return this.typeable;
        }

        public void setTypeable(Typeable typeable) {
            this.typeable = typeable;
        }
    }

    public static class Typed
    implements Typeable {
        @Override
        public String getType() {
            return "x";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Typed.class, name="x")})
    public static interface Typeable {
        public String getType();
    }
}

