/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.util.Collection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpClientUtilsTest {
    HttpClientUtilsTest() {
    }

    @Test
    void testCreateApplicableInterceptors() {
        Config config = new ConfigBuilder().build();
        Collection interceptorList = HttpClientUtils.createApplicableInterceptors((Config)config, null).values();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(interceptorList).isNotNull()).hasSize(4)).hasAtLeastOneElementOfType(BackwardsCompatibilityInterceptor.class)).hasAtLeastOneElementOfType(ImpersonatorInterceptor.class)).hasAtLeastOneElementOfType(TokenRefreshInterceptor.class);
    }

    @Test
    void testCreateApplicableInterceptorsWithBackwardsCompatibilityDisabled() {
        Config config = new ConfigBuilder().build();
        System.setProperty("kubernetes.backwardsCompatibilityInterceptor.disable", "true");
        Collection interceptorList = HttpClientUtils.createApplicableInterceptors((Config)config, null).values();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(interceptorList).isNotNull()).hasSize(3)).noneMatch(i -> i instanceof BackwardsCompatibilityInterceptor)).hasAtLeastOneElementOfType(ImpersonatorInterceptor.class)).hasAtLeastOneElementOfType(TokenRefreshInterceptor.class);
        System.clearProperty("kubernetes.backwardsCompatibilityInterceptor.disable");
    }
}

