/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.okhttp;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OkHttpClientFactoryTest {
    OkHttpClientFactoryTest() {
    }

    @Test
    void shouldRespectMaxRequests() {
        OkHttpClientImpl client = new OkHttpClientFactory().createHttpClient(new ConfigBuilder().build());
        Assertions.assertEquals((int)64, (int)client.getOkHttpClient().dispatcher().getMaxRequests());
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequests(120)).build();
        client = new OkHttpClientFactory().createHttpClient(config);
        Assertions.assertEquals((int)120, (int)client.getOkHttpClient().dispatcher().getMaxRequests());
    }

    @Test
    void shouldRespectMaxRequestsPerHost() {
        OkHttpClientImpl client = new OkHttpClientFactory().createHttpClient(new ConfigBuilder().build());
        Assertions.assertEquals((int)5, (int)client.getOkHttpClient().dispatcher().getMaxRequestsPerHost());
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequestsPerHost(20)).build();
        client = new OkHttpClientFactory().createHttpClient(config);
        Assertions.assertEquals((int)20, (int)client.getOkHttpClient().dispatcher().getMaxRequestsPerHost());
    }
}

