/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.authorization.v1.LocalSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SubjectAccessReview;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.scheduling.v1beta1.PriorityClass;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachment;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.client.lib.FileSystem;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class UtilsTest {
    UtilsTest() {
    }

    @Test
    void existingSysPropShouldReturnValue() {
        System.setProperty("something", "value");
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"something"));
        System.getProperties().remove("something");
    }

    @Test
    void missingSysPropAndEnvVarShouldReturnNull() {
        Assertions.assertNull((Object)Utils.getSystemPropertyOrEnvVar((String)"doesn't exist"));
    }

    @Test
    void existingEnvVarShouldReturnValue() {
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"ENV_VAR_EXISTS"));
    }

    @Test
    void existingEnvVarShouldReturnValueFromConvertedSysPropName() {
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists"));
    }

    @Test
    void existingEnvVarShouldReturnBooleanValueFromConvertedSysPropName() {
        Assertions.assertTrue((boolean)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists.boolean", (Boolean)false));
    }

    @Test
    void missingEnvVarShouldReturnDefaultValue() {
        Assertions.assertTrue((boolean)Utils.getSystemPropertyOrEnvVar((String)"DONT_EXIST", (Boolean)true));
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and empty parameters, should return input")
    void interpolateStringTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", Collections.emptyMap());
        Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and null parameters, should return input")
    void interpolateStringNullParametersTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", null);
        Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and null parameter values, should return input")
    void interpolateStringNullParameterValuesTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", Collections.singletonMap("KEY", null));
        Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with mixed placeholders and parameters, should return interpolated input")
    void interpolateStringWithParametersTest() {
        String input = "This is a \"${SINGLE_CURLY_BRACE}\" and the following is code ${NOT_REPLACED}: \"${{RENDER_UNQUOTED}}\" ${{ALREADY_UNQUOTED}}";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SINGLE_CURLY_BRACE", "template string");
        parameters.put("RENDER_UNQUOTED", "'1' === '1';");
        parameters.put("ALREADY_UNQUOTED", "/* END */");
        parameters.put("NOT_THERE", "/* END */");
        parameters.put(null, "NULL key is ignored");
        parameters.put("NULL_VALUE", null);
        String result = Utils.interpolateString((String)"This is a \"${SINGLE_CURLY_BRACE}\" and the following is code ${NOT_REPLACED}: \"${{RENDER_UNQUOTED}}\" ${{ALREADY_UNQUOTED}}", parameters);
        Assertions.assertEquals((Object)"This is a \"template string\" and the following is code ${NOT_REPLACED}: '1' === '1'; /* END */", (Object)result);
    }

    @Test
    void testGetPluralFromKind() {
        TreeMap<String, Class> pluralToKubernetesResourceMap = new TreeMap<String, Class>();
        pluralToKubernetesResourceMap.put("bindings", Binding.class);
        pluralToKubernetesResourceMap.put("componentstatuses", ComponentStatus.class);
        pluralToKubernetesResourceMap.put("configmaps", ConfigMap.class);
        pluralToKubernetesResourceMap.put("endpoints", Endpoints.class);
        pluralToKubernetesResourceMap.put("events", Event.class);
        pluralToKubernetesResourceMap.put("limitranges", LimitRange.class);
        pluralToKubernetesResourceMap.put("namespaces", Namespace.class);
        pluralToKubernetesResourceMap.put("nodes", Node.class);
        pluralToKubernetesResourceMap.put("persistentvolumeclaims", PersistentVolumeClaim.class);
        pluralToKubernetesResourceMap.put("persistentvolumes", PersistentVolume.class);
        pluralToKubernetesResourceMap.put("pods", Pod.class);
        pluralToKubernetesResourceMap.put("podtemplates", PodTemplate.class);
        pluralToKubernetesResourceMap.put("replicationcontrollers", ReplicationController.class);
        pluralToKubernetesResourceMap.put("resourcequotas", ResourceQuota.class);
        pluralToKubernetesResourceMap.put("secrets", Secret.class);
        pluralToKubernetesResourceMap.put("serviceaccounts", ServiceAccount.class);
        pluralToKubernetesResourceMap.put("services", Service.class);
        pluralToKubernetesResourceMap.put("mutatingwebhookconfigurations", MutatingWebhookConfiguration.class);
        pluralToKubernetesResourceMap.put("validatingwebhookconfigurations", ValidatingWebhookConfiguration.class);
        pluralToKubernetesResourceMap.put("customresourcedefinitions", CustomResourceDefinition.class);
        pluralToKubernetesResourceMap.put("controllerrevisions", ControllerRevision.class);
        pluralToKubernetesResourceMap.put("daemonsets", DaemonSet.class);
        pluralToKubernetesResourceMap.put("deployments", Deployment.class);
        pluralToKubernetesResourceMap.put("replicasets", ReplicaSet.class);
        pluralToKubernetesResourceMap.put("statefulsets", StatefulSet.class);
        pluralToKubernetesResourceMap.put("tokenreviews", TokenReview.class);
        pluralToKubernetesResourceMap.put("localsubjectaccessreviews", LocalSubjectAccessReview.class);
        pluralToKubernetesResourceMap.put("selfsubjectaccessreviews", SelfSubjectAccessReview.class);
        pluralToKubernetesResourceMap.put("selfsubjectrulesreviews", SelfSubjectRulesReview.class);
        pluralToKubernetesResourceMap.put("subjectaccessreviews", SubjectAccessReview.class);
        pluralToKubernetesResourceMap.put("horizontalpodautoscalers", HorizontalPodAutoscaler.class);
        pluralToKubernetesResourceMap.put("cronjobs", CronJob.class);
        pluralToKubernetesResourceMap.put("jobs", Job.class);
        pluralToKubernetesResourceMap.put("certificatesigningrequests", CertificateSigningRequest.class);
        pluralToKubernetesResourceMap.put("leases", Lease.class);
        pluralToKubernetesResourceMap.put("endpointslices", EndpointSlice.class);
        pluralToKubernetesResourceMap.put("ingresses", Ingress.class);
        pluralToKubernetesResourceMap.put("networkpolicies", NetworkPolicy.class);
        pluralToKubernetesResourceMap.put("poddisruptionbudgets", PodDisruptionBudget.class);
        pluralToKubernetesResourceMap.put("podsecuritypolicies", PodSecurityPolicy.class);
        pluralToKubernetesResourceMap.put("clusterrolebindings", ClusterRoleBinding.class);
        pluralToKubernetesResourceMap.put("clusterroles", ClusterRole.class);
        pluralToKubernetesResourceMap.put("rolebindings", RoleBinding.class);
        pluralToKubernetesResourceMap.put("roles", Role.class);
        pluralToKubernetesResourceMap.put("priorityclasses", PriorityClass.class);
        pluralToKubernetesResourceMap.put("csidrivers", CSIDriver.class);
        pluralToKubernetesResourceMap.put("csinodes", CSINode.class);
        pluralToKubernetesResourceMap.put("storageclasses", StorageClass.class);
        pluralToKubernetesResourceMap.put("volumeattachments", VolumeAttachment.class);
        pluralToKubernetesResourceMap.forEach((plural, kubernetesResource) -> Assertions.assertEquals((Object)plural, (Object)Utils.getPluralFromKind((String)kubernetesResource.getSimpleName())));
    }

    @Test
    @DisplayName(value="Should test whether resource is namespaced or not")
    void testWhetherNamespacedOrNot() {
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Binding.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ComponentStatus.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ConfigMap.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Endpoints.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Event.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(LimitRange.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(Namespace.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(Node.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(PersistentVolumeClaim.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(PersistentVolume.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Pod.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(PodTemplate.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ReplicationController.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ResourceQuota.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Secret.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ServiceAccount.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Service.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(MutatingWebhookConfiguration.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ValidatingWebhookConfiguration.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CustomResourceDefinition.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ControllerRevision.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(DaemonSet.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Deployment.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ReplicaSet.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(StatefulSet.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(TokenReview.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(LocalSubjectAccessReview.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(SelfSubjectAccessReview.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(SelfSubjectRulesReview.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(SubjectAccessReview.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(HorizontalPodAutoscaler.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(CronJob.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Job.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CertificateSigningRequest.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Lease.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(EndpointSlice.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Ingress.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(NetworkPolicy.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(PodDisruptionBudget.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(PodSecurityPolicy.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ClusterRoleBinding.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ClusterRole.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(RoleBinding.class));
        Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Role.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(PriorityClass.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CSIDriver.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CSINode.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(StorageClass.class));
        Assertions.assertFalse((boolean)Utils.isResourceNamespaced(VolumeAttachment.class));
    }

    @Test
    @DisplayName(value="isNotNullOrEmpty, null, should return false")
    void isNotNullOrEmpty() {
        boolean result1 = Utils.isNotNullOrEmpty((Map)null);
        boolean result2 = Utils.isNotNullOrEmpty((String)null);
        boolean result3 = Utils.isNotNullOrEmpty((String)"");
        Assertions.assertFalse((boolean)result1);
        Assertions.assertFalse((boolean)result2);
        Assertions.assertFalse((boolean)result3);
    }

    @Test
    @DisplayName(value="isNotNull, null, should return false")
    void isNotNull() {
        Object[] emptyArray = new String[]{};
        boolean result = Utils.isNotNull((Object[])emptyArray);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="isNotNullOrEmpty, some null values, should return true")
    void isNotNullOrEmptySomeAreNullTest() {
        String[] testSample = new String[]{"notNullObj", null, null};
        boolean result = Utils.isNotNullOrEmpty((String[])testSample);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="isNotNull, some null values, should return true")
    void isNotNullSomeAreNullTest() {
        Object[] testSample = new String[]{"notNullObj", null, null};
        boolean result = Utils.isNotNull((Object[])testSample);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    @DisplayName(value="isNotNull, no null values, should return true")
    void isNotNullNoneAreNullTest() {
        Object[] testSample = new String[]{"Not null", "Not null either"};
        boolean result = Utils.isNotNull((Object[])testSample);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="test getting system path")
    void testGetSystemPathVariable() {
        String pathVariable = Utils.getSystemPathVariable();
        Assertions.assertNotNull((Object)pathVariable);
        Assertions.assertTrue((boolean)pathVariable.contains(File.pathSeparator));
    }

    @Test
    @DisplayName(value="Should get command prefix")
    void testGetCommandPlatformPrefix() {
        List commandPrefix = Utils.getCommandPlatformPrefix();
        Assertions.assertNotNull((Object)commandPrefix);
        Assertions.assertEquals((int)2, (int)commandPrefix.size());
        switch (FileSystem.getCurrent()) {
            case WINDOWS: {
                Assertions.assertEquals((Object)"cmd.exe", commandPrefix.get(0));
                Assertions.assertEquals((Object)"/c", commandPrefix.get(1));
                break;
            }
            default: {
                Assertions.assertEquals((Object)"sh", commandPrefix.get(0));
                Assertions.assertEquals((Object)"-c", commandPrefix.get(1));
            }
        }
    }

    @Test
    void testDaemonThreadFactory() {
        ThreadFactory tf = Utils.daemonThreadFactory((Object)this);
        Thread t = tf.newThread(() -> {});
        Assertions.assertTrue((boolean)t.isDaemon());
        Assertions.assertTrue((boolean)t.getName().startsWith(UtilsTest.class.getSimpleName()));
    }
}

