/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.run;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.SimpleClientContext;
import io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.client.extended.run.RunOperations;
import io.fabric8.kubernetes.client.http.HttpClient;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class RunOperationsTest {
    private HttpClient mockClient;
    private Config config;

    RunOperationsTest() {
    }

    @BeforeEach
    public void init() {
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
    }

    @Test
    void testConvertRunConfigIntoPod() {
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        limits.put("cpu", new Quantity("200m"));
        limits.put("memory", new Quantity("512Mi"));
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        requests.put("memory", new Quantity("64Mi"));
        requests.put("cpu", new Quantity("150m"));
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("first", "FIRST");
        labels.put("second", "SECOND");
        RunConfigBuilder generatorRunConfig = (RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)new RunConfigBuilder().withName("test")).withImage("test:latest")).withLabels(labels)).withEnv(Collections.singletonMap("TEST_KEY", "TEST_VALUE"))).withImagePullPolicy("IfNotPresent")).withRestartPolicy("OnFailure")).withServiceAccount("ribbon")).withPort(5701)).withLimits(limits)).withRequests(requests);
        RunOperations deploymentGenerator = new RunOperations((ClientContext)new SimpleClientContext(this.config, this.mockClient), "ns1", generatorRunConfig);
        Pod pod = deploymentGenerator.convertRunConfigIntoPod();
        Assertions.assertNotNull((Object)pod);
        Assertions.assertEquals((Object)"test", (Object)pod.getMetadata().getName());
        Assertions.assertEquals((Object)"FIRST", pod.getMetadata().getLabels().get("first"));
        Assertions.assertEquals((Object)"SECOND", pod.getMetadata().getLabels().get("second"));
        Assertions.assertEquals((Object)"test", pod.getMetadata().getLabels().get("run"));
        Assertions.assertNotNull((Object)pod.getSpec());
        Assertions.assertEquals((Object)"OnFailure", (Object)pod.getSpec().getRestartPolicy());
        Assertions.assertEquals((Object)"ribbon", (Object)pod.getSpec().getServiceAccountName());
        Assertions.assertEquals((Object)"test", (Object)((Container)pod.getSpec().getContainers().get(0)).getName());
        Assertions.assertEquals((Object)"IfNotPresent", (Object)((Container)pod.getSpec().getContainers().get(0)).getImagePullPolicy());
        Assertions.assertEquals((Object)"test:latest", (Object)((Container)pod.getSpec().getContainers().get(0)).getImage());
        Assertions.assertEquals((int)1, (int)((Container)pod.getSpec().getContainers().get(0)).getEnv().size());
        Assertions.assertEquals((int)1, (int)((Container)pod.getSpec().getContainers().get(0)).getPorts().size());
        Assertions.assertEquals((int)5701, (Integer)((ContainerPort)((Container)pod.getSpec().getContainers().get(0)).getPorts().get(0)).getContainerPort());
        Assertions.assertEquals((Object)"TEST_KEY", (Object)((EnvVar)((Container)pod.getSpec().getContainers().get(0)).getEnv().get(0)).getName());
        Assertions.assertEquals((Object)"TEST_VALUE", (Object)((EnvVar)((Container)pod.getSpec().getContainers().get(0)).getEnv().get(0)).getValue());
        Assertions.assertEquals((Object)new Quantity("200m"), ((Container)pod.getSpec().getContainers().get(0)).getResources().getLimits().get("cpu"));
        Assertions.assertEquals((Object)new Quantity("512Mi"), ((Container)pod.getSpec().getContainers().get(0)).getResources().getLimits().get("memory"));
        Assertions.assertEquals((Object)new Quantity("150m"), ((Container)pod.getSpec().getContainers().get(0)).getResources().getRequests().get("cpu"));
        Assertions.assertEquals((Object)new Quantity("64Mi"), ((Container)pod.getSpec().getContainers().get(0)).getResources().getRequests().get("memory"));
    }
}

