/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.KubernetesVersionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class KubernetesVersionFactoryTest {
    @Test
    public void create_should_create_kubernetes_version() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.create((String)"v42beta1");
        Assertions.assertThat((Comparable)version).isInstanceOf(KubernetesVersionFactory.KubernetesVersion.class);
    }

    @Test
    public void create_should_create_non_kubernetes_version() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.create((String)"darthVader");
        Assertions.assertThat((Comparable)version).isInstanceOf(KubernetesVersionFactory.NonKubernetesVersion.class);
    }

    @Test
    public void create_should_create_nonkubernetes_version_when_version_has_illegal_qualifier() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("v1gamma");
        boolean isKubernetes = version.isKubernetes();
        Assertions.assertThat((boolean)isKubernetes).isFalse();
    }

    @Test
    public void create_should_create_nonkubernetes_version_when_version_is_missing_major() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.create((String)"vbeta");
        boolean isKubernetes = version.isKubernetes();
        Assertions.assertThat((boolean)isKubernetes).isFalse();
    }

    @Test
    public void isKubernetes_should_return_true_for_kubernetes_version() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v84");
        boolean isKubernetes = version.isKubernetes();
        Assertions.assertThat((boolean)isKubernetes).isTrue();
    }

    @Test
    public void isKubernetes_should_return_false_for_non_kubernetes_version() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("darthVader");
        boolean isKubernetes = version.isKubernetes();
        Assertions.assertThat((boolean)isKubernetes).isFalse();
    }

    @Test
    public void FactoryCreate_should_create_kubernetes_version_when_version_is_kubernetes_version() {
        KubernetesVersionFactory.Version version = KubernetesVersionFactory.create((String)"v10beta42");
        boolean isKubernetes = version.isKubernetes();
        Assertions.assertThat((boolean)isKubernetes).isTrue();
    }

    @Test
    public void isStable_should_report_stable_when_there_is_no_qualifier() {
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v1");
        boolean stable = version.isStable();
        Assertions.assertThat((boolean)stable).isTrue();
    }

    @Test
    public void isStable_should_report_unstable_when_there_is_a_qualifier() {
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha");
        boolean stable = version.isStable();
        Assertions.assertThat((boolean)stable).isFalse();
    }

    @Test
    public void getMajor_should_return_major() {
        Integer majorInteger = 1;
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v" + majorInteger + "beta42");
        Integer major = version.getMajor();
        Assertions.assertThat((Integer)major).isEqualTo((Object)majorInteger);
    }

    @Test
    public void getQualifier_should_return_qualifier() {
        String beta = "beta";
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v422" + beta + "442");
        Optional qualifier = version.getQualifier();
        Assertions.assertThat((String)((String)qualifier.get())).isEqualTo(beta);
    }

    @Test
    public void getQualifier_should_return_empty_optional_qualifier_when_there_is_no_qualifier() {
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v422");
        Optional qualifier = version.getQualifier();
        Assertions.assertThat((Optional)qualifier).isNotPresent();
    }

    @Test
    public void getMinor_should_return_minor() {
        Integer minorInteger = 42;
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v1alpha" + minorInteger);
        Optional minor = version.getMinor();
        Assertions.assertThat((Integer)((Integer)minor.get())).isEqualTo((Object)minorInteger);
    }

    @Test
    public void getMinor_should_return_empty_optional_when_there_is_no_minor() {
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v1alpha");
        Optional minor = version.getMinor();
        Assertions.assertThat((Optional)minor).isNotPresent();
    }

    @Test
    public void toString_kubernetesVersion_should_return_original_version_for_GA_version() {
        String versionString = "v42";
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create(versionString);
        String toString = version.toString();
        Assertions.assertThat((String)toString).isEqualTo(versionString);
    }

    @Test
    public void toString_kubernetesVersion_should_return_original_version_for_unstable_version() {
        String versionString = "v42beta42";
        KubernetesVersionFactory.KubernetesVersion version = (KubernetesVersionFactory.KubernetesVersion)KubernetesVersionFactory.KubernetesVersion.FACTORY.create(versionString);
        String toString = version.toString();
        Assertions.assertThat((String)toString).isEqualTo(versionString);
    }

    @Test
    public void compareTo_kubernetesVersion_should_be_greater_than_nonKubernetesVersion() {
        KubernetesVersionFactory.Version kVersion = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta42");
        KubernetesVersionFactory.Version nkVersion = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("lukeSkywalker");
        Assertions.assertThat((Comparable)kVersion).isGreaterThan((Comparable)nkVersion);
    }

    @Test
    public void compareTo_nonKubernetesVersion_should_be_less_than_kubernetesVersion() {
        KubernetesVersionFactory.Version kVersion = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta42");
        KubernetesVersionFactory.Version nkVersion = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("lukeSkywalker");
        Assertions.assertThat((Comparable)nkVersion).isLessThan((Comparable)kVersion);
    }

    @Test
    public void compareTo_same_major_version_should_be_same_as_other_major() {
        KubernetesVersionFactory.Version version42_1 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42");
        KubernetesVersionFactory.Version version42_2 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42");
        int majorComparison = version42_1.compareTo((Object)version42_2);
        Assertions.assertThat((int)majorComparison).isZero();
    }

    @Test
    public void compareTo_kubernetesVersion_with_greater_major_version_should_be_greater_than_smaller_major_version() {
        KubernetesVersionFactory.Version version42 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42");
        KubernetesVersionFactory.Version version84 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v84");
        Assertions.assertThat((Comparable)version84).isGreaterThan((Comparable)version42);
    }

    @Test
    public void compareTo_kubernetesVersion_with_smaller_major_should_be_less_than_greater_major() {
        KubernetesVersionFactory.Version version42 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42");
        KubernetesVersionFactory.Version version84 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v84");
        Assertions.assertThat((Comparable)version42).isLessThan((Comparable)version84);
    }

    @Test
    public void compareTo_kubernetesVersion_with_alpha_qualifier_should_be_less_than_beta_qualifier() {
        KubernetesVersionFactory.Version alpha = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha");
        KubernetesVersionFactory.Version beta = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta");
        Assertions.assertThat((Comparable)alpha).isLessThan((Comparable)beta);
    }

    @Test
    public void compareTo_kubernetesVersion_with_beta_qualifier_should_be_greater_than_alpha_qualifier() {
        KubernetesVersionFactory.Version alpha = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha");
        KubernetesVersionFactory.Version beta = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta");
        Assertions.assertThat((Comparable)beta).isGreaterThan((Comparable)alpha);
    }

    @Test
    public void compareTo_GA_kubernetesVersion_should_be_greater_than_beta_qualifier() {
        KubernetesVersionFactory.Version ga = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42");
        KubernetesVersionFactory.Version beta = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta");
        Assertions.assertThat((Comparable)ga).isGreaterThan((Comparable)beta);
    }

    @Test
    public void compareTo_kubernetesVersion_same_qualifier_should_be_same_as_other_qualifier() {
        KubernetesVersionFactory.Version beta1 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta");
        KubernetesVersionFactory.Version beta2 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta");
        int qualifierComparison = beta1.compareTo((Object)beta2);
        Assertions.assertThat((int)qualifierComparison).isZero();
    }

    @Test
    public void compareTo_beta_kubernetesVersion_should_be_less_than_GA() {
        KubernetesVersionFactory.Version ga = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42");
        KubernetesVersionFactory.Version beta = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta");
        Assertions.assertThat((Comparable)beta).isLessThan((Comparable)ga);
    }

    @Test
    public void compareTo_kubernetesVersion_greater_minor_should_be_greater_than_smaller_minor() {
        KubernetesVersionFactory.Version minor42 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha42");
        KubernetesVersionFactory.Version minor84 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha84");
        Assertions.assertThat((Comparable)minor84).isGreaterThan((Comparable)minor42);
    }

    @Test
    public void compareTo_kubernetesVersion_smaller_minor_should_be_smaller_than_greater_minor() {
        KubernetesVersionFactory.Version minor42 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta42");
        KubernetesVersionFactory.Version minor84 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42beta84");
        Assertions.assertThat((Comparable)minor42).isLessThan((Comparable)minor84);
    }

    @Test
    public void compareTo_kubernetesVersion_minor_should_be_same_as_other_minor() {
        KubernetesVersionFactory.Version minor42_1 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha42");
        KubernetesVersionFactory.Version minor42_2 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha42");
        int minorComparison = minor42_1.compareTo((Object)minor42_2);
        Assertions.assertThat((int)minorComparison).isZero();
    }

    @Test
    public void compareTo_kubernetesVersion_without_minor_should_be_less_than_version_with_minor() {
        KubernetesVersionFactory.Version noMinor = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha");
        KubernetesVersionFactory.Version minor42 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha42");
        Assertions.assertThat((Comparable)noMinor).isLessThan((Comparable)minor42);
    }

    @Test
    public void compareTo_kubernetesVersion_with_minor_should_be_greater_than_version_without_minor() {
        KubernetesVersionFactory.Version noMinor = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha");
        KubernetesVersionFactory.Version minor42 = KubernetesVersionFactory.KubernetesVersion.FACTORY.create("v42alpha42");
        Assertions.assertThat((Comparable)minor42).isGreaterThan((Comparable)noMinor);
    }

    @Test
    public void compareTo_nonKubernetesVersion_should_be_same_as_other_with_same_version() {
        KubernetesVersionFactory.Version skywalker1_1 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker1");
        KubernetesVersionFactory.Version skywalker1_2 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker1");
        int minorComparison = skywalker1_1.compareTo((Object)skywalker1_2);
        Assertions.assertThat((int)minorComparison).isZero();
    }

    @Test
    public void compareTo_nonKubernetesVersion_with_minor_should_be_less_than_version_without_minor() {
        KubernetesVersionFactory.Version skywalker = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker");
        KubernetesVersionFactory.Version skywalker1 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker1");
        Assertions.assertThat((Comparable)skywalker1).isLessThan((Comparable)skywalker);
    }

    @Test
    public void compareTo_nonKubernetesVersion_with_greater_minor_should_be_less_than_version_with_smaller_minor() {
        KubernetesVersionFactory.Version skywalker1 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker1");
        KubernetesVersionFactory.Version skywalker10 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker10");
        Assertions.assertThat((Comparable)skywalker10).isLessThan((Comparable)skywalker1);
    }

    @Test
    public void compareTo_nonKubernetesVersion_with_smaller_minor_should_be_less_than_version_with_greater_minor() {
        KubernetesVersionFactory.Version skywalker1 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker1");
        KubernetesVersionFactory.Version skywalker10 = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("skywalker10");
        Assertions.assertThat((Comparable)skywalker1).isGreaterThan((Comparable)skywalker10);
    }

    @Test
    public void compareTo_nonKubernetesVersion_alphabetically_lower_char_should_be_greater() {
        KubernetesVersionFactory.Version a = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("a");
        KubernetesVersionFactory.Version b = KubernetesVersionFactory.NonKubernetesVersion.FACTORY.create("b");
        Assertions.assertThat((Comparable)a).isGreaterThan((Comparable)b);
    }

    @Test
    public void should_sort_spec_example_correctly() {
        KubernetesVersionFactory.Version v10 = KubernetesVersionFactory.create((String)"v10");
        KubernetesVersionFactory.Version v2 = KubernetesVersionFactory.create((String)"v2");
        KubernetesVersionFactory.Version v1 = KubernetesVersionFactory.create((String)"v1");
        KubernetesVersionFactory.Version v11beta2 = KubernetesVersionFactory.create((String)"v11beta2");
        KubernetesVersionFactory.Version v10beta3 = KubernetesVersionFactory.create((String)"v10beta3");
        KubernetesVersionFactory.Version v3beta1 = KubernetesVersionFactory.create((String)"v3beta1");
        KubernetesVersionFactory.Version v12alpha1 = KubernetesVersionFactory.create((String)"v12alpha1");
        KubernetesVersionFactory.Version v11alpha2 = KubernetesVersionFactory.create((String)"v11alpha2");
        KubernetesVersionFactory.Version foo1 = KubernetesVersionFactory.create((String)"foo1");
        KubernetesVersionFactory.Version foo10 = KubernetesVersionFactory.create((String)"foo10");
        List<KubernetesVersionFactory.Version> versions = Arrays.asList(foo10, v11alpha2, foo1, v3beta1, v2, v10beta3, v11beta2, v1, v12alpha1, v10);
        List sorted = versions.stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        Assertions.assertThat(sorted).containsExactly((Object[])new KubernetesVersionFactory.Version[]{v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10});
    }
}

