/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TokenRefreshInterceptorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAutoconfigureAfter401() throws IOException {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-tokeninterceptor")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            Interceptor.Chain chain = (Interceptor.Chain)Mockito.mock(Interceptor.Chain.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Request req = new Request.Builder().url("http://mock").build();
            Mockito.when((Object)chain.request()).thenReturn((Object)req);
            Response.Builder responseBuilder = new Response.Builder().request(req).protocol(Protocol.HTTP_1_1).message("").body(ResponseBody.create((MediaType)MediaType.parse((String)"text"), (String)"foo"));
            Mockito.when((Object)chain.proceed((Request)Mockito.any())).thenReturn((Object)responseBuilder.code(401).build(), (Object[])new Response[]{responseBuilder.code(200).build()});
            new TokenRefreshInterceptor(Config.autoConfigure(null)).intercept(chain);
            ((Interceptor.Chain)Mockito.verify((Object)chain)).proceed((Request)Mockito.argThat(argument -> "Bearer token".equals(argument.header("Authorization"))));
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReloadInClusterServiceAccount() throws IOException {
        try {
            File tokenFile = Files.createTempFile("test", "token", new FileAttribute[0]).toFile();
            Files.write(tokenFile.toPath(), "expired".getBytes(), new OpenOption[0]);
            System.setProperty("kubernetes.auth.serviceAccount.token", tokenFile.getAbsolutePath());
            System.setProperty("kubernetes.auth.tryKubeConfig", "false");
            Interceptor.Chain chain = (Interceptor.Chain)Mockito.mock(Interceptor.Chain.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Request req = new Request.Builder().url("http://mock").build();
            Mockito.when((Object)chain.request()).thenReturn((Object)req);
            Response.Builder responseBuilder = new Response.Builder().request(req).protocol(Protocol.HTTP_1_1).message("").body(ResponseBody.create((MediaType)MediaType.parse((String)"text"), (String)"foo"));
            Mockito.when((Object)chain.proceed((Request)Mockito.any())).thenReturn((Object)responseBuilder.code(401).build(), (Object[])new Response[]{responseBuilder.code(200).build()});
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(Config.autoConfigure(null));
            Files.write(tokenFile.toPath(), "renewed".getBytes(), new OpenOption[0]);
            interceptor.intercept(chain);
            ((Interceptor.Chain)Mockito.verify((Object)chain)).proceed((Request)Mockito.argThat(argument -> "Bearer renewed".equals(argument.header("Authorization"))));
        }
        finally {
            System.clearProperty("kubernetes.auth.serviceAccount.token");
            System.clearProperty("kubernetes.auth.tryKubeConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldRefreshOIDCToken() throws IOException {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            Interceptor.Chain chain = (Interceptor.Chain)Mockito.mock(Interceptor.Chain.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Request req = new Request.Builder().url("http://mock").build();
            Mockito.when((Object)chain.request()).thenReturn((Object)req);
            Response.Builder responseBuilder = new Response.Builder().request(req).protocol(Protocol.HTTP_1_1).message("").body(ResponseBody.create((MediaType)MediaType.parse((String)"text"), (String)"foo"));
            Mockito.when((Object)chain.proceed((Request)Mockito.any())).thenReturn((Object)responseBuilder.code(401).build(), (Object[])new Response[]{responseBuilder.code(200).build()});
            Config config = Config.autoConfigure(null);
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/test-kubeconfig-tokeninterceptor-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            new TokenRefreshInterceptor(config).intercept(chain);
            ((Interceptor.Chain)Mockito.verify((Object)chain)).proceed((Request)Mockito.argThat(argument -> "Bearer renewed".equals(argument.header("Authorization"))));
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }
}

