/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mockito.Mockito;

public class PodMockUtils {
    public static PodMockBuilder pod(String name) {
        return new PodMockBuilder(name);
    }

    public static PodCondition condition(String type, String status) {
        PodCondition mock = (PodCondition)Mockito.mock(PodCondition.class);
        Mockito.when((Object)mock.getType()).thenReturn((Object)type);
        Mockito.when((Object)mock.getStatus()).thenReturn((Object)status);
        return mock;
    }

    public static ContainerStatus containerStatus(ContainerState state) {
        return PodMockUtils.containerStatus(false, state);
    }

    public static ContainerStatus containerStatus(Boolean ready, ContainerState state) {
        ContainerStatus mock = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mock.getReady()).thenReturn((Object)ready);
        Mockito.when((Object)mock.getState()).thenReturn((Object)state);
        return mock;
    }

    public static ContainerState containerState(ContainerStateTerminated terminated, ContainerStateWaiting waiting, ContainerStateRunning running) {
        ContainerState mock = (ContainerState)Mockito.mock(ContainerState.class);
        Mockito.when((Object)mock.getTerminated()).thenReturn((Object)terminated);
        Mockito.when((Object)mock.getWaiting()).thenReturn((Object)waiting);
        Mockito.when((Object)mock.getRunning()).thenReturn((Object)running);
        return mock;
    }

    public static ContainerStateTerminated containerStateTerminated(Integer exitCode, String reason) {
        ContainerStateTerminated mock = (ContainerStateTerminated)Mockito.mock(ContainerStateTerminated.class);
        Mockito.when((Object)mock.getExitCode()).thenReturn((Object)exitCode);
        Mockito.when((Object)mock.getReason()).thenReturn((Object)reason);
        return mock;
    }

    public static ContainerStateWaiting containerStateWaiting(String reason) {
        ContainerStateWaiting mock = (ContainerStateWaiting)Mockito.mock(ContainerStateWaiting.class);
        Mockito.when((Object)mock.getReason()).thenReturn((Object)reason);
        return mock;
    }

    public static ContainerStateRunning containerStateRunning() {
        return (ContainerStateRunning)Mockito.mock(ContainerStateRunning.class);
    }

    public static class PodStatusMockBuilder {
        private final PodMockBuilder parent;
        private String phase;
        private String reason;
        private List<ContainerStatus> initContainerStatuses = Collections.emptyList();
        private List<ContainerStatus> containerStatuses = Collections.emptyList();
        private List<PodCondition> podConditions = Collections.emptyList();

        private PodStatusMockBuilder(PodMockBuilder parent) {
            this.parent = parent;
        }

        public PodStatusMockBuilder phase(String phase) {
            this.phase = phase;
            return this;
        }

        public PodStatusMockBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public PodStatusMockBuilder initContainerStatuses(List<ContainerStatus> initContainerStatuses) {
            this.initContainerStatuses = initContainerStatuses;
            return this;
        }

        public PodStatusMockBuilder initContainerStatuses(ContainerStatus ... initContainerStatuses) {
            return this.initContainerStatuses(Arrays.asList(initContainerStatuses));
        }

        public PodStatusMockBuilder containerStatuses(List<ContainerStatus> containerStatuses) {
            this.containerStatuses = containerStatuses;
            return this;
        }

        public PodStatusMockBuilder containerStatuses(ContainerStatus ... containerStatuses) {
            return this.containerStatuses(Arrays.asList(containerStatuses));
        }

        public PodStatusMockBuilder podConditions(List<PodCondition> podConditions) {
            this.podConditions = podConditions;
            return this;
        }

        public PodStatusMockBuilder podConditions(PodCondition ... podConditions) {
            return this.podConditions(Arrays.asList(podConditions));
        }

        public PodMockBuilder build() {
            this.parent.status(this.phase, this.reason, this.initContainerStatuses, this.containerStatuses, this.podConditions);
            return this.parent;
        }
    }

    static class PodMockBuilder {
        private final String name;
        private final String namespace;
        private final String uid;
        private PodStatus status;
        private String timestamp;

        PodMockBuilder(String name) {
            this(name, null, String.valueOf(System.currentTimeMillis()));
        }

        PodMockBuilder(String name, String namespace, String uid) {
            this.name = name;
            this.namespace = namespace;
            this.uid = uid;
        }

        public PodMockBuilder setInitializing() {
            ContainerStatus containerStatus = PodMockUtils.containerStatus(PodMockUtils.containerState(PodMockUtils.containerStateTerminated(42, null), null, null));
            this.initContainerStatus(Collections.singletonList(containerStatus));
            return this;
        }

        public PodMockBuilder status(PodStatus status) {
            this.status = status;
            return this;
        }

        public PodStatusMockBuilder statusBuilder() {
            return new PodStatusMockBuilder(this);
        }

        public PodMockBuilder status(String phase, String reason) {
            return this.status(phase, reason, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public PodMockBuilder initContainerStatus() {
            return this.initContainerStatus(Collections.singletonList(PodMockUtils.containerStatus(null, null)));
        }

        public PodMockBuilder initContainerStatus(List<ContainerStatus> initContainerStatus) {
            return this.status(null, null, initContainerStatus, Collections.emptyList(), Collections.emptyList());
        }

        public PodMockBuilder status(String phase, String reason, List<ContainerStatus> initContainerStatuses, List<ContainerStatus> containerStatuses, List<PodCondition> conditions) {
            PodStatus mock = (PodStatus)Mockito.mock(PodStatus.class);
            Mockito.when((Object)mock.getPhase()).thenReturn((Object)phase);
            Mockito.when((Object)mock.getReason()).thenReturn((Object)reason);
            Mockito.when((Object)mock.getInitContainerStatuses()).thenReturn(initContainerStatuses);
            Mockito.when((Object)mock.getContainerStatuses()).thenReturn(containerStatuses);
            Mockito.when((Object)mock.getConditions()).thenReturn(conditions);
            return this.status(mock);
        }

        public PodMockBuilder deletion(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Pod build() {
            Pod pod = this.pod(this.name, this.namespace, this.uid);
            Mockito.when((Object)pod.getStatus()).thenReturn((Object)this.status);
            Mockito.when((Object)pod.getMetadata().getDeletionTimestamp()).thenReturn((Object)this.timestamp);
            return pod;
        }

        private Pod pod(String name, String namespace, String uid) {
            ObjectMeta metadata = this.metadata(name, namespace, uid);
            Pod mock = (Pod)Mockito.mock(Pod.class);
            Mockito.when((Object)mock.getMetadata()).thenReturn((Object)metadata);
            Mockito.when((Object)mock.getApiVersion()).thenReturn((Object)"PodMock");
            Mockito.when((Object)mock.getKind()).thenReturn((Object)Pod.class.getSimpleName());
            return mock;
        }

        private ObjectMeta metadata() {
            return this.metadata(null, null, null);
        }

        private ObjectMeta metadata(String name, String namespace, String uid) {
            ObjectMeta metaData = (ObjectMeta)Mockito.mock(ObjectMeta.class);
            Mockito.when((Object)metaData.getName()).thenReturn((Object)name);
            Mockito.when((Object)metaData.getNamespace()).thenReturn((Object)namespace);
            Mockito.when((Object)metaData.getUid()).thenReturn((Object)uid);
            return metaData;
        }
    }
}

