/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.utils.PodMockUtils;
import io.fabric8.kubernetes.client.utils.PodStatusUtil;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PodStatusUtilTest {
    private ContainerStatus runningReady = PodMockUtils.containerStatus(true, PodMockUtils.containerState(null, null, PodMockUtils.containerStateRunning()));

    @Test
    public void isRunning_should_return_true_if_pod_is_in_phase_running() {
        Pod pod = PodMockUtils.pod("starwars").status("Running", "<Darth Vader has lost its sabre>").build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isTrue();
    }

    @Test
    public void isRunning_should_return_true_if_pod_has_reason_running() {
        Pod pod = PodMockUtils.pod("anakin").status("<transition to the dark side>", "Running").build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isTrue();
    }

    @Test
    public void isRunning_should_return_false_if_pod_has_deletion_Timestamp() {
        Pod pod = PodMockUtils.pod("some pod").status("", "").deletion("2020-06-10").build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isFalse();
    }

    @Test
    public void isRunning_should_return_false_if_pod_is_initializing() {
        Pod pod = PodMockUtils.pod("some pod").setInitializing().build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isFalse();
    }

    @Test
    public void isInitializing_should_return_false_if_pod_has_no_initContainerStatus() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().build().build();
        boolean initializing = PodStatusUtil.isInitializing((Pod)pod);
        Assertions.assertThat((boolean)initializing).isFalse();
    }

    @Test
    public void isInitializing_should_return_true_if_pod_has_initContainerStatus_without_state() {
        Pod pod = PodMockUtils.pod("some pod").initContainerStatus().build();
        boolean initializing = PodStatusUtil.isInitializing((Pod)pod);
        Assertions.assertThat((boolean)initializing).isTrue();
    }

    @Test
    public void isInitializing_should_return_true_if_pod_has_initContainerStatus_without_terminated_value_nor_waiting_value() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().initContainerStatuses(PodMockUtils.containerStatus(false, PodMockUtils.containerState(null, null, null))).build().build();
        boolean initializing = PodStatusUtil.isInitializing((Pod)pod);
        Assertions.assertThat((boolean)initializing).isTrue();
    }

    @Test
    public void isInitializing_should_return_true_if_pod_has_initContainerStatus_without_terminated_value_but_waiting_value() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().initContainerStatuses(PodMockUtils.containerStatus(false, PodMockUtils.containerState(null, PodMockUtils.containerStateWaiting("WaitingForTheBus"), null))).build().build();
        boolean initializing = PodStatusUtil.isInitializing((Pod)pod);
        Assertions.assertThat((boolean)initializing).isTrue();
    }

    @Test
    public void isInitializing_should_return_false_if_pod_has_initContainerStatus_without_terminated_value_but_waiting_value_PodInitializing() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().initContainerStatuses(PodMockUtils.containerStatus(false, PodMockUtils.containerState(null, PodMockUtils.containerStateWaiting("PodInitializing"), null))).build().build();
        boolean initializing = PodStatusUtil.isInitializing((Pod)pod);
        Assertions.assertThat((boolean)initializing).isFalse();
    }

    @Test
    public void isInitializing_should_return_false_if_pod_has_initContainerStatus_with_state_with_exit_code_0() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().initContainerStatuses(PodMockUtils.containerStatus(false, PodMockUtils.containerState(PodMockUtils.containerStateTerminated(0, null), null, null))).build().build();
        boolean initializing = PodStatusUtil.isInitializing((Pod)pod);
        Assertions.assertThat((boolean)initializing).isFalse();
    }

    @Test
    public void isRunning_should_return_true_if_pod_has_containerStatus_ready_and_running() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().containerStatuses(this.runningReady).build().build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isTrue();
    }

    @Test
    public void isRunning_should_return_false_if_pod_has_containerStatus_ready_but_not_running() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().containerStatuses(PodMockUtils.containerStatus(true, PodMockUtils.containerState(null, null, null))).build().build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isFalse();
    }

    @Test
    public void isRunning_should_return_true_if_pod_has_running_container_and_another_that_is_completed_and_ready_condition_is_true() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().containerStatuses(this.runningReady, PodMockUtils.containerStatus(false, PodMockUtils.containerState(PodMockUtils.containerStateTerminated(null, "Completed"), null, null))).podConditions(PodMockUtils.condition("Ready", "true")).build().build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isTrue();
    }

    @Test
    public void isRunning_should_return_false_if_pod_has_running_container_and_another_that_is_completed_and_ready_condition_is_false() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().containerStatuses(this.runningReady, PodMockUtils.containerStatus(false, PodMockUtils.containerState(PodMockUtils.containerStateTerminated(null, "Completed"), null, null))).podConditions(PodMockUtils.condition("Ready", "false")).build().build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isFalse();
    }

    @Test
    public void isRunning_should_return_true_if_pod_has_running_container_and_another_that_is_terminated_for_other_reason_than_completed() {
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().containerStatuses(this.runningReady, PodMockUtils.containerStatus(false, PodMockUtils.containerState(PodMockUtils.containerStateTerminated(null, "I was bored"), null, null))).build().build();
        boolean running = PodStatusUtil.isRunning((Pod)pod);
        Assertions.assertThat((boolean)running).isTrue();
    }

    @Test
    public void getContainersStatuses_should_return_all_containers() {
        ContainerStatus waitingReady = PodMockUtils.containerStatus(true, PodMockUtils.containerState(null, PodMockUtils.containerStateWaiting(null), null));
        ContainerStatus terminatedNonReady = PodMockUtils.containerStatus(false, PodMockUtils.containerState(PodMockUtils.containerStateTerminated(null, null), null, null));
        Pod pod = PodMockUtils.pod("some pod").statusBuilder().containerStatuses(this.runningReady, waitingReady, terminatedNonReady).build().build();
        List containers = PodStatusUtil.getContainerStatus((Pod)pod);
        Assertions.assertThat((List)containers).containsExactlyInAnyOrder((Object[])new ContainerStatus[]{this.runningReady, waitingReady, terminatedNonReady});
    }

    @Test
    public void getContainersStatuses_should_return_emptyList_if_pod_has_no_status() {
        Pod pod = PodMockUtils.pod("some pod").build();
        Assertions.assertThat((Object)pod.getStatus()).isNull();
        List containers = PodStatusUtil.getContainerStatus((Pod)pod);
        Assertions.assertThat((List)containers).isEmpty();
    }
}

