/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class RawCustomResourceOperationsImplTest {
    private OkHttpClient mockClient;
    private Config config;
    private CustomResourceDefinitionContext customResourceDefinitionContext;
    private Response mockSuccessResponse;

    @BeforeEach
    public void setUp() throws IOException {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.customResourceDefinitionContext = new CustomResourceDefinitionContext.Builder().withGroup("test.fabric8.io").withName("hellos.test.fabric8.io").withPlural("hellos").withScope("Namespaced").withVersion("v1alpha1").build();
        Call mockCall = (Call)Mockito.mock(Call.class);
        this.mockSuccessResponse = this.mockResponse(200);
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)this.mockSuccessResponse);
        Mockito.when((Object)this.mockClient.newCall((Request)Mockito.any())).thenReturn((Object)mockCall);
    }

    @Test
    void testCreateOrReplaceUrl() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        String resourceAsString = "{\"metadata\":{\"name\":\"myresource\",\"namespace\":\"myns\"}, \"kind\":\"raw\", \"apiVersion\":\"v1\"}";
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Call mockCall = (Call)Mockito.mock(Call.class);
        Response mockErrorResponse = this.mockResponse(500);
        Response mockConflictResponse = this.mockResponse(409);
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)mockErrorResponse, (Object[])new Response[]{mockConflictResponse, this.mockSuccessResponse});
        Mockito.when((Object)this.mockClient.newCall((Request)Mockito.any())).thenReturn((Object)mockCall);
        try {
            rawCustomResourceOperations.createOrReplace(resourceAsString);
            org.junit.jupiter.api.Assertions.fail((String)"expected first call to createOrReplace to throw exception due to 500 response");
        }
        catch (KubernetesClientException e) {
            org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)e.getCode());
        }
        rawCustomResourceOperations.createOrReplace(resourceAsString);
        rawCustomResourceOperations.createOrReplace("myns", resourceAsString);
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)4))).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)captor.getAllValues().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/hellos", (Object)((Request)captor.getAllValues().get(0)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"POST", (Object)((Request)captor.getAllValues().get(0)).method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/hellos", (Object)((Request)captor.getAllValues().get(1)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"POST", (Object)((Request)captor.getAllValues().get(1)).method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/hellos/myresource", (Object)((Request)captor.getAllValues().get(2)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"PUT", (Object)((Request)captor.getAllValues().get(2)).method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", (Object)((Request)captor.getAllValues().get(3)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"POST", (Object)((Request)captor.getAllValues().get(3)).method());
    }

    private Response mockResponse(int code) {
        return new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(code).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)"")).message("mock").build();
    }

    @Test
    void testGetUrl() {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.get("myns", "myresource");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testDeleteUrl() throws IOException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        rawCustomResourceOperations.delete("myns", "myresource");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", (Object)((Request)captor.getValue()).url().encodedPath());
    }

    @Test
    void testFetchWatchUrlWithNamespace() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl("test", null, null, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithNamespaceAndName() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl("test", "example-resource", null, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?fieldSelector=metadata.name%3Dexample-resource&watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithNamespaceAndNameAndResourceVersion() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl("test", "example-resource", null, ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("100069")).withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?fieldSelector=metadata.name%3Dexample-resource&resourceVersion=100069&watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithoutAnything() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl(null, null, null, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8443/apis/test.fabric8.io/v1alpha1/hellos?watch=true", (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithLabels() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("foo", "bar");
        labels.put("foo1", "bar1");
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl(null, null, labels, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("https://localhost:8443/apis/test.fabric8.io/v1alpha1/hellos?labelSelector=" + Utils.toUrlEncoded((String)"foo=bar") + "," + Utils.toUrlEncoded((String)"foo1=bar1") + "&watch=true"), (Object)url.url().toString());
    }

    @Test
    void testFetchWatchUrlWithLabelsWithNamespace() throws MalformedURLException {
        RawCustomResourceOperationsImpl rawCustomResourceOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.customResourceDefinitionContext);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("foo", "bar");
        labels.put("foo1", "bar1");
        HttpUrl url = rawCustomResourceOperations.fetchWatchUrl("test", null, labels, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("https://localhost:8443/apis/test.fabric8.io/v1alpha1/namespaces/test/hellos?labelSelector=" + Utils.toUrlEncoded((String)"foo=bar") + "," + Utils.toUrlEncoded((String)"foo1=bar1") + "&watch=true"), (Object)url.url().toString());
    }

    @Test
    void testGetConfigShouldNotReturnNull() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withRequestTimeout(5)).withWebsocketTimeout(10L)).withWebsocketPingInterval(10L)).withConnectionTimeout(10)).withWatchReconnectLimit(1)).withWatchReconnectInterval(10)).build();
        RawCustomResourceOperationsImpl rawOp = new RawCustomResourceOperationsImpl(this.mockClient, config, this.customResourceDefinitionContext);
        Config configFromRawOp = rawOp.getConfig();
        Assertions.assertThat((Object)configFromRawOp).isNotNull();
        Assertions.assertThat((int)configFromRawOp.getRequestTimeout()).isEqualTo(5);
        Assertions.assertThat((long)configFromRawOp.getWebsocketTimeout()).isEqualTo(10L);
        Assertions.assertThat((long)configFromRawOp.getWebsocketPingInterval()).isEqualTo(10L);
        Assertions.assertThat((int)configFromRawOp.getConnectionTimeout()).isEqualTo(10L);
        Assertions.assertThat((int)configFromRawOp.getWatchReconnectInterval()).isEqualTo(10);
        Assertions.assertThat((int)configFromRawOp.getWatchReconnectLimit()).isEqualTo(1);
    }
}

