/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.Custom;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Good;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class CustomResourceTest {
    CustomResourceTest() {
    }

    @Test
    void missingGroupAndVersionShouldFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MissingApiVersion());
    }

    @Test
    void valuesShouldProperlyBeComputedFromDefaultsAndAnnotations() {
        Good good = new Good();
        Assertions.assertEquals((Object)"Good", (Object)good.getKind());
        Assertions.assertEquals((Object)"goods", (Object)good.getPlural());
        Assertions.assertEquals((Object)"good", (Object)good.getSingular());
        Assertions.assertEquals((Object)"sample.fabric8.io/v1beta1", (Object)good.getApiVersion());
        Assertions.assertEquals((Object)(good.getPlural() + "." + "sample.fabric8.io"), (Object)good.getCRDName());
        Assertions.assertEquals((Object)"v1beta1", (Object)good.getVersion());
        Assertions.assertEquals((Object)"sample.fabric8.io", (Object)good.getGroup());
        Assertions.assertTrue((boolean)good.isServed());
        Assertions.assertTrue((boolean)good.isStorage());
    }

    @Test
    @DisplayName(value="fully annotated custom resource should use annotation values instead of defaults")
    void customCRShouldWork() {
        Custom custom = new Custom();
        Assertions.assertEquals((Object)"CustomCR", (Object)custom.getKind());
        Assertions.assertEquals((Object)"foo", (Object)custom.getSingular());
        Assertions.assertEquals((Object)"fooes", (Object)custom.getPlural());
        Assertions.assertEquals((Object)"sample.fabric8.io/v1beta1", (Object)custom.getApiVersion());
        Assertions.assertEquals((Object)(custom.getPlural() + "." + "sample.fabric8.io"), (Object)custom.getCRDName());
        Assertions.assertEquals((Object)"v1beta1", (Object)custom.getVersion());
        Assertions.assertEquals((Object)"sample.fabric8.io", (Object)custom.getGroup());
        Assertions.assertFalse((boolean)custom.isServed());
        Assertions.assertFalse((boolean)custom.isStorage());
    }

    @Test
    void untypedCustomResourceInitShouldWork() {
        Untyped cr = new Untyped();
        Assertions.assertNull((Object)cr.getSpec());
        Assertions.assertNull((Object)cr.getStatus());
    }

    @Test
    void voidVoidCustomResourceInitShouldWork() {
        VoidVoid cr = new VoidVoid();
        Assertions.assertNull((Object)cr.getSpec());
        Assertions.assertNull((Object)cr.getStatus());
    }

    @Test
    void noSpecCustomResourceInitShouldWork() {
        NoSpec cr = new NoSpec();
        Assertions.assertNull((Object)cr.getSpec());
        Assertions.assertEquals((Object)"", (Object)cr.getStatus());
    }

    @Test
    void subclassInitShouldWork() {
        CRC cr = new CRC();
        Assertions.assertEquals((Object)"", (Object)cr.getSpec());
        Assertions.assertEquals((Object)new Foo(), (Object)cr.getStatus());
    }

    @Test
    void subclassWithOverriddenInitShouldWork() {
        CRI cri = new CRI();
        Assertions.assertEquals((Object)"", (Object)cri.getSpec());
        Assertions.assertEquals((int)7, (Integer)((Integer)cri.getStatus()));
    }

    @Test
    void subclassWithVoidStatusShouldWork() {
        CRV crv = new CRV();
        Assertions.assertEquals((Object)"", (Object)crv.getSpec());
        Assertions.assertNull((Object)crv.getStatus());
    }

    @Test
    void deeperSubclassShouldWork() {
        CRGG cr = new CRGG();
        Assertions.assertEquals((Object)"", (Object)cr.getSpec());
        Assertions.assertEquals((Object)new Foo(), (Object)cr.getStatus());
    }

    @Test
    void implicitConstructorShouldWork() {
        CRImplicit cr = new CRImplicit();
        Assertions.assertEquals((Object)new Bar(), (Object)cr.getSpec());
        Assertions.assertEquals((Object)"", (Object)cr.getStatus());
    }

    @Test
    void interfaceTypeShouldFail() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new CRInterface());
        Assertions.assertTrue((boolean)exception.getMessage().contains(KubernetesResource.class.getName()));
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class VoidVoid
    extends CustomResource<Void, Void> {
        private VoidVoid() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class NoSpec
    extends CustomResource<Void, String> {
        private NoSpec() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRInterface
    extends CustomResource<String, KubernetesResource> {
        private CRInterface() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRImplicit
    extends CustomResource<Bar, String> {
        private CRImplicit() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRGG
    extends CRG {
        private CRGG() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRG
    extends CRC {
        private CRG() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRC
    extends CustomResource<String, Foo> {
        private CRC() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRI
    extends CustomResource<String, Integer> {
        private CRI() {
        }

        protected Integer initStatus() {
            return 7;
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRV
    extends CustomResource<String, Void> {
        private CRV() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class Untyped
    extends CustomResource {
        private Untyped() {
        }
    }

    private static class Bar {
        private Bar() {
        }

        public boolean equals(Object obj) {
            return obj instanceof Bar;
        }
    }

    private static class Foo {
        public boolean equals(Object obj) {
            return obj instanceof Foo;
        }
    }

    private static class MissingApiVersion
    extends CustomResource {
        private MissingApiVersion() {
        }
    }
}

