
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyBuilder;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyList;

import java.util.Map;
import java.util.TreeMap;


public class PodSecurityPolicyOperationsImpl extends HasMetadataOperation<PodSecurityPolicy, PodSecurityPolicyList, Resource<PodSecurityPolicy>> {

  public PodSecurityPolicyOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public PodSecurityPolicyOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PodSecurityPolicyOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("policy")
    .withApiGroupVersion("v1beta1")
    .withPlural("podsecuritypolicies"));
    this.type = PodSecurityPolicy.class;
    this.listType = PodSecurityPolicyList.class;
  }

  public PodSecurityPolicyOperationsImpl newInstance(OperationContext context) {
    return new PodSecurityPolicyOperationsImpl(context);
  }

  @Override
  public PodSecurityPolicy edit(Visitor... visitors) {
    return patch(new PodSecurityPolicyBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
