/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Operation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl;
import okhttp3.OkHttpClient;

class ReplicaSetRollingUpdater
extends RollingUpdater<ReplicaSet, ReplicaSetList> {
    ReplicaSetRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    ReplicaSetRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicaSet createClone(ReplicaSet obj, String newName, String newDeploymentHash) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)((ReplicaSetFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)((ReplicaSetFluent.MetadataNested)new ReplicaSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(Integer.valueOf(0))).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(ReplicaSet obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected ReplicaSet updateDeploymentKey(String name, String hash) {
        return (ReplicaSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).edit(r -> ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)new ReplicaSetBuilder(r).editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build());
    }

    @Override
    protected ReplicaSet removeDeploymentKey(String name) {
        return (ReplicaSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).edit(r -> ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)new ReplicaSetBuilder(r).editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build());
    }

    @Override
    protected int getReplicas(ReplicaSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicaSet setReplicas(ReplicaSet obj, int replicas) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)new ReplicaSetBuilder(obj).editSpec().withReplicas(Integer.valueOf(replicas))).endSpec()).build();
    }

    @Override
    protected Operation<ReplicaSet, ReplicaSetList, RollableScalableResource<ReplicaSet>> resources() {
        return new ReplicaSetOperationsImpl(this.client, this.config);
    }
}

