/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.osgi;

import io.fabric8.kubernetes.api.model.APIService;
import io.fabric8.kubernetes.api.model.APIServiceList;
import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.OAuthTokenProvider;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.SettingsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.client.extended.run.RunOperations;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.kubernetes.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class, NamespacedKubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter"), @Reference(referenceInterface=OAuthTokenProvider.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, bind="bindOAuthTokenProvider", unbind="unbindOAuthTokenProvider")})
public class ManagedKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    private NamespacedKubernetesClient delegate;
    private OAuthTokenProvider provider;

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigBuilder builder = new ConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        if (properties.containsKey("kubernetes.truststore.file")) {
            builder.withTrustStoreFile((String)properties.get("kubernetes.truststore.file"));
        }
        if (properties.containsKey("kubernetes.truststore.passphrase")) {
            builder.withTrustStorePassphrase((String)properties.get("kubernetes.truststore.passphrase"));
        }
        if (properties.containsKey("kubernetes.keystore.file")) {
            builder.withKeyStoreFile((String)properties.get("kubernetes.keystore.file"));
        }
        if (properties.containsKey("kubernetes.keystore.passphrase")) {
            builder.withKeyStorePassphrase((String)properties.get("kubernetes.keystore.passphrase"));
        }
        if (this.provider != null) {
            builder.withOauthTokenProvider(this.provider);
        }
        this.delegate = new DefaultKubernetesClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return this.delegate.bindings();
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<io.fabric8.kubernetes.api.model.Service, ServiceList, ServiceResource<io.fabric8.kubernetes.api.model.Service>> services() {
        return this.delegate.services();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public MixedOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return this.delegate.apiServices();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Event, EventList, Resource<Event>> events() {
        return this.delegate.events();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.delegate.v1();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.delegate.admissionRegistration();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.delegate.scheduling();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public SettingsAPIGroupDSL settings() {
        return this.delegate.settings();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.delegate.top();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, Resource<CustomResourceDefinition>> customResourceDefinitions() {
        return this.delegate.customResourceDefinitions();
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.delegate.apiextensions();
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return this.delegate.certificateSigningRequests();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public Createable<TokenReview> tokenReviews() {
        return this.delegate.tokenReviews();
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return this.delegate.customResources(resourceType);
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return this.delegate.customResources(resourceType, listClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(CustomResourceDefinitionContext crdContext, Class<T> resourceType, Class<L> listClass) {
        return this.delegate.customResources(crdContext, resourceType, listClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass) {
        return this.delegate.customResources(crd, resourceType, listClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass) {
        return this.customResources(crd, resourceType, listClass);
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return this.delegate.customResource(customResourceDefinition);
    }

    @Override
    public SharedInformerFactory informers() {
        return this.delegate.informers();
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return this.delegate.informers(executorService);
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return this.delegate.leaderElector();
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return this.delegate.leases();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }

    public void bindOAuthTokenProvider(OAuthTokenProvider provider) {
        this.provider = provider;
    }

    public void unbindOAuthTokenProvider(OAuthTokenProvider provider) {
        if (this.provider == provider) {
            this.provider = null;
        }
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return (NamespacedKubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return (NamespacedKubernetesClient)this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this.httpClient, this.getConfiguration(), this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return this.delegate.runtimeClasses();
    }
}

