package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.lang.Boolean;
import org.slf4j.Logger;
import java.util.Map;

public interface CustomResourceFluent<S,T,A extends CustomResourceFluent<S,T,A>> extends Fluent<A> {


    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public S getSpec();
    public A withSpec(S spec);
    public Boolean hasSpec();
    public T getStatus();
    public A withStatus(T status);
    public Boolean hasStatus();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
}
