/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUploadWebSocketListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodUploadTest {
    private OkHttpClient mockClient;
    private PodOperationContext mockContext;
    private OperationSupport operationSupport;
    private Path mockPathToUpload;
    private WebSocket mockWebSocket;

    PodUploadTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockContext = (PodOperationContext)Mockito.mock(PodOperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.operationSupport = (OperationSupport)Mockito.mock(OperationSupport.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockPathToUpload = (Path)Mockito.mock(Path.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockWebSocket = (WebSocket)Mockito.mock(WebSocket.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockClient.newBuilder().readTimeout(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class))).build()).thenReturn((Object)this.mockClient);
        Mockito.when((Object)this.operationSupport.getResourceUrl()).thenReturn((Object)new URL("https://openshift.com:8443/api/v1/namespaces/default/pods/mock-pod/"));
    }

    @AfterEach
    void tearDown() {
        this.mockClient = null;
        this.mockContext = null;
        this.operationSupport = null;
        this.mockPathToUpload = null;
    }

    @Test
    void testUploadInvalidParametersShouldThrowException() throws Exception {
        IllegalArgumentException result = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PodUpload.upload((OkHttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (Path)this.mockPathToUpload));
        MatcherAssert.assertThat((Object)result.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Provided arguments are not valid (file, directory, path)"));
    }

    @Test
    void testUploadFileHappyScenarioShouldUploadFile() throws Exception {
        Mockito.when((Object)this.mockContext.getFile()).thenReturn((Object)"/mock/dir/file");
        Mockito.when((Object)this.mockPathToUpload.toFile()).thenReturn((Object)new File(PodUpload.class.getResource("/upload/upload-sample.txt").getFile()));
        Mockito.when((Object)this.mockClient.newWebSocket((Request)ArgumentMatchers.any(), (WebSocketListener)ArgumentMatchers.any())).thenAnswer(newWebSocket -> {
            PodUploadWebSocketListener wsl = (PodUploadWebSocketListener)newWebSocket.getArgument(1, PodUploadWebSocketListener.class);
            wsl.onOpen(this.mockWebSocket, null);
            wsl.onMessage(this.mockWebSocket, ByteString.of((byte[])new byte[]{0}));
            Mockito.when((Object)this.mockWebSocket.close(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenAnswer(close -> {
                wsl.onClosed(this.mockWebSocket, ((Integer)close.getArgument(0)).intValue(), (String)close.getArgument(1));
                return true;
            });
            return this.mockWebSocket;
        });
        boolean result = PodUpload.upload((OkHttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (Path)this.mockPathToUpload);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        ((Path)Mockito.verify((Object)this.mockPathToUpload, (VerificationMode)Mockito.atLeast((int)1))).toFile();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).newWebSocket((Request)ArgumentMatchers.argThat(request -> {
            MatcherAssert.assertThat((Object)request.url().toString(), (Matcher)CoreMatchers.equalTo((Object)"https://openshift.com:8443/api/v1/namespaces/default/pods/mock-pod/exec?command=sh&command=-c&command=mkdir+-p+%2Fmock%2Fdir+%26%26+base64+-d+-+%3E+%2Fmock%2Fdir%2Ffile&stdin=true&stderr=true"));
            return true;
        }), (WebSocketListener)ArgumentMatchers.any(PodUploadWebSocketListener.class));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.atLeast((int)1))).send((ByteString)ArgumentMatchers.any(ByteString.class));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.times((int)0))).send(ArgumentMatchers.anyString());
    }

    @Test
    void testUploadDirectoryHappyScenarioShouldUploadDirectory() throws Exception {
        Mockito.when((Object)this.mockContext.getDir()).thenReturn((Object)"/mock/dir");
        Mockito.when((Object)this.mockPathToUpload.toFile()).thenReturn((Object)new File(PodUpload.class.getResource("/upload").getFile()));
        Mockito.when((Object)this.mockClient.newWebSocket((Request)ArgumentMatchers.any(), (WebSocketListener)ArgumentMatchers.any())).thenAnswer(newWebSocket -> {
            PodUploadWebSocketListener wsl = (PodUploadWebSocketListener)newWebSocket.getArgument(1, PodUploadWebSocketListener.class);
            wsl.onOpen(this.mockWebSocket, null);
            wsl.onMessage(this.mockWebSocket, ByteString.of((byte[])new byte[]{0}));
            Mockito.when((Object)this.mockWebSocket.close(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenAnswer(close -> {
                wsl.onClosed(this.mockWebSocket, ((Integer)close.getArgument(0)).intValue(), (String)close.getArgument(1));
                return true;
            });
            return this.mockWebSocket;
        });
        boolean result = PodUpload.upload((OkHttpClient)this.mockClient, (PodOperationContext)this.mockContext, (OperationSupport)this.operationSupport, (Path)this.mockPathToUpload);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        ((Path)Mockito.verify((Object)this.mockPathToUpload, (VerificationMode)Mockito.atLeast((int)1))).toFile();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).newWebSocket((Request)ArgumentMatchers.argThat(request -> {
            MatcherAssert.assertThat((Object)request.url().toString(), (Matcher)CoreMatchers.equalTo((Object)"https://openshift.com:8443/api/v1/namespaces/default/pods/mock-pod/exec?command=sh&command=-c&command=mkdir+-p+%2Fmock%2Fdir+%26%26+base64+-d+-+%7C+tar+-C+%2Fmock%2Fdir+-xzf+-&stdin=true&stderr=true"));
            return true;
        }), (WebSocketListener)ArgumentMatchers.any(PodUploadWebSocketListener.class));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.atLeast((int)1))).send((ByteString)ArgumentMatchers.any(ByteString.class));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.times((int)0))).send(ArgumentMatchers.anyString());
    }

    @Test
    void testCopy() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("I'LL BE COPIED".getBytes(Charset.defaultCharset()));
        ObjIntConsumer<byte[]> consumer = (bytes, length) -> {
            MatcherAssert.assertThat((Object)length, (Matcher)CoreMatchers.equalTo((Object)14));
            MatcherAssert.assertThat((Object)new String(Arrays.copyOf(bytes, 14), Charset.defaultCharset()), (Matcher)CoreMatchers.equalTo((Object)"I'LL BE COPIED"));
        };
        PodUpload.copy((InputStream)input, consumer);
    }
}

