/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class AbstractWatchManagerTest {
    private MockedStatic<Executors> executors;
    private ScheduledExecutorService executorService;

    AbstractWatchManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.executors = Mockito.mockStatic(Executors.class);
        this.executors.when(() -> Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any())).thenReturn((Object)this.executorService);
    }

    @AfterEach
    void tearDown() {
        this.executors.close();
    }

    @Test
    @DisplayName(value="closeEvent, is idempotent, multiple calls only close watcher once")
    void closeEventIsIdempotent() {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.closeEvent();
        }
        Assertions.assertThat((int)watcher.closeCount.get()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="closeEvent with Exception, is idempotent, multiple calls only close watcher once")
    void closeEventWithExceptionIsIdempotent() {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.closeEvent(new WatcherException("Mock"));
        }
        Assertions.assertThat((int)watcher.closeCount.get()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="closeWebSocket, closes web socket with 1000 code (Normal Closure)")
    void closeWebSocket() {
        WebSocket webSocket = (WebSocket)Mockito.mock(WebSocket.class);
        AbstractWatchManager.closeWebSocket((WebSocket)webSocket);
        ((WebSocket)Mockito.verify((Object)webSocket, (VerificationMode)Mockito.times((int)1))).close(1000, null);
    }

    @Test
    @DisplayName(value="closeExecutorService, with graceful termination")
    void closeExecutorServiceGracefully() throws InterruptedException {
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(null);
        Mockito.when((Object)this.executorService.awaitTermination(1L, TimeUnit.SECONDS)).thenReturn((Object)true);
        awm.closeExecutorService();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).shutdown();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)0))).shutdownNow();
    }

    @Test
    @DisplayName(value="closeExecutorService, with shutdownNow")
    void closeExecutorServiceNow() throws InterruptedException {
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(null);
        Mockito.when((Object)this.executorService.awaitTermination(1L, TimeUnit.SECONDS)).thenReturn((Object)false);
        awm.closeExecutorService();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).shutdown();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).shutdownNow();
    }

    @Test
    @DisplayName(value="submit, executor not shutdown, should submit")
    void submitWhenIsNotShutdown() {
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(null);
        awm.submit(() -> {});
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
    }

    @Test
    @DisplayName(value="submit, executor shutdown, should NOT submit")
    void submitWhenIsShutdown() {
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(null);
        Mockito.when((Object)this.executorService.isShutdown()).thenReturn((Object)true);
        awm.submit(() -> {});
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)0))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
    }

    @Test
    @DisplayName(value="schedule, executor not shutdown, should submit")
    void scheduleWhenIsNotShutdown() {
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(null);
        awm.schedule(() -> {}, 0L, TimeUnit.SECONDS);
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)1))).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test
    @DisplayName(value="schedule, executor shutdown, should NOT submit")
    void scheduleWhenIsShutdown() {
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(null);
        Mockito.when((Object)this.executorService.isShutdown()).thenReturn((Object)true);
        awm.schedule(() -> {}, 0L, TimeUnit.SECONDS);
        ((ScheduledExecutorService)Mockito.verify((Object)this.executorService, (VerificationMode)Mockito.times((int)0))).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test
    @DisplayName(value="nextReconnectInterval, returns exponential interval values up to the provided limit")
    void nextReconnectInterval() {
        WatchManager awm = new WatchManager(null, (ListOptions)Mockito.mock(ListOptions.class), 0, 10, 5, null);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(10L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(20L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(40L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(80L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(160L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(320L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(320L);
    }

    private static <T> WatchManager<T> withDefaultWatchManager(Watcher<T> watcher) {
        return new WatchManager<T>(watcher, (ListOptions)Mockito.mock(ListOptions.class, (Answer)Mockito.RETURNS_DEEP_STUBS), 0, 0, 0, (OkHttpClient)Mockito.mock(OkHttpClient.class));
    }

    private static final class WatchManager<T>
    extends AbstractWatchManager<T> {
        public WatchManager(Watcher<T> watcher, ListOptions listOptions, int reconnectLimit, int reconnectInterval, int maxIntervalExponent, OkHttpClient clonedClient) {
            super(watcher, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, clonedClient);
        }

        public void close() {
        }
    }

    private static class WatcherAdapter<T>
    implements Watcher<T> {
        private final AtomicInteger closeCount = new AtomicInteger(0);

        private WatcherAdapter() {
        }

        public void eventReceived(Watcher.Action action, T resource) {
        }

        public void onClose(WatcherException cause) {
            this.closeCount.addAndGet(1);
        }

        public void onClose() {
            this.closeCount.addAndGet(1);
        }
    }
}

