/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.cache.DeltaFIFO;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListener<T>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessorListener.class);
    private long resyncPeriodInMillis;
    private ZonedDateTime nextResync;
    private BlockingQueue<Notification<T>> queue;
    private ResourceEventHandler<T> handler;

    public ProcessorListener(ResourceEventHandler<T> handler, long resyncPeriodInMillis) {
        this.resyncPeriodInMillis = resyncPeriodInMillis;
        this.handler = handler;
        this.queue = new LinkedBlockingQueue<Notification<T>>();
        this.determineNextResync(ZonedDateTime.now());
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.queue.take().handle(this.handler);
                }
            }
            catch (InterruptedException ex) {
                log.error("Processor thread interrupted: {}", (Object)ex.getMessage());
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception ex) {
                log.error("Failed invoking {} event handler: {}", (Object)ex.getMessage());
                continue;
            }
            break;
        }
    }

    public void add(Notification<T> obj) {
        Optional.ofNullable(obj).ifPresent(this.queue::add);
    }

    public void determineNextResync(ZonedDateTime now) {
        this.nextResync = now.plus(this.resyncPeriodInMillis, ChronoUnit.MILLIS);
    }

    public boolean shouldResync(ZonedDateTime now) {
        return this.resyncPeriodInMillis != 0L && (now.isAfter(this.nextResync) || now.equals(this.nextResync));
    }

    public static final class DeleteNotification<T>
    extends Notification<T> {
        public DeleteNotification(T oldObject) {
            super(oldObject, null);
        }

        @Override
        public void handle(ResourceEventHandler<T> resourceEventHandler) {
            if (this.getOldObject() instanceof DeltaFIFO.DeletedFinalStateUnknown) {
                resourceEventHandler.onDelete(((DeltaFIFO.DeletedFinalStateUnknown)this.getOldObject()).getObj(), true);
            } else {
                resourceEventHandler.onDelete(this.getOldObject(), false);
            }
        }
    }

    public static final class AddNotification<T>
    extends Notification<T> {
        public AddNotification(T newObject) {
            super(null, newObject);
        }

        @Override
        public void handle(ResourceEventHandler<T> resourceEventHandler) {
            resourceEventHandler.onAdd(this.getNewObject());
        }
    }

    public static final class UpdateNotification<T>
    extends Notification<T> {
        public UpdateNotification(T oldObject, T newObject) {
            super(oldObject, newObject);
        }

        @Override
        public void handle(ResourceEventHandler<T> resourceEventHandler) {
            resourceEventHandler.onUpdate(this.getOldObject(), this.getNewObject());
        }
    }

    public static abstract class Notification<T> {
        private final T oldObject;
        private final T newObject;

        public Notification(T oldObject, T newObject) {
            this.oldObject = oldObject;
            this.newObject = newObject;
        }

        public T getOldObject() {
            return this.oldObject;
        }

        public T getNewObject() {
            return this.newObject;
        }

        public abstract void handle(ResourceEventHandler<T> var1);
    }
}

