
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerList;

import java.util.Map;
import java.util.TreeMap;


public class HorizontalPodAutoscalerOperationsImpl extends HasMetadataOperation<HorizontalPodAutoscaler, HorizontalPodAutoscalerList, Resource<HorizontalPodAutoscaler>> {

  public HorizontalPodAutoscalerOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public HorizontalPodAutoscalerOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public HorizontalPodAutoscalerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("autoscaling")
    .withApiGroupVersion("v2beta1")
    .withPlural("horizontalpodautoscalers"));
    this.type = HorizontalPodAutoscaler.class;
    this.listType = HorizontalPodAutoscalerList.class;
  }

  public HorizontalPodAutoscalerOperationsImpl newInstance(OperationContext context) {
    return new HorizontalPodAutoscalerOperationsImpl(context);
  }

  @Override
  public HorizontalPodAutoscaler edit(Visitor... visitors) {
    return patch(new HorizontalPodAutoscalerBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
