/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.NamedRunnable;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawWatchConnectionManager
extends AbstractWatchManager<String> {
    private static final Logger logger = LoggerFactory.getLogger(RawWatchConnectionManager.class);
    private ObjectMapper objectMapper;
    private HttpUrl.Builder watchUrlBuilder;
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean reconnectPending = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);

    public RawWatchConnectionManager(OkHttpClient okHttpClient, HttpUrl.Builder watchUrlBuilder, ListOptions listOptions, ObjectMapper objectMapper, Watcher<String> watcher, int reconnectLimit, int reconnectInterval, int maxIntervalExponent) {
        super(watcher, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, okHttpClient.newBuilder().build());
        this.watchUrlBuilder = watchUrlBuilder;
        this.objectMapper = objectMapper;
        this.runWatch();
    }

    private void runWatch() {
        if (this.resourceVersion.get() != null) {
            this.watchUrlBuilder.removeAllQueryParameters("resourceVersion");
            this.watchUrlBuilder.addQueryParameter("resourceVersion", (String)this.resourceVersion.get());
        }
        HttpUrl watchUrl = this.watchUrlBuilder.build();
        String origin = watchUrl.url().getProtocol() + "://" + watchUrl.url().getHost();
        if (watchUrl.url().getPort() != -1) {
            origin = origin + ":" + watchUrl.url().getPort();
        }
        Request request = new Request.Builder().get().url(watchUrl).addHeader("Origin", origin).build();
        this.clonedClient.newWebSocket(request, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                logger.info("Websocket opened");
                RawWatchConnectionManager.this.webSocketRef.set(webSocket);
                RawWatchConnectionManager.this.currentReconnectAttempt.set(0);
                RawWatchConnectionManager.this.started.set(true);
                RawWatchConnectionManager.this.queue.clear();
                RawWatchConnectionManager.this.queue.add(true);
            }

            public void onMessage(WebSocket webSocket, String text) {
                try {
                    Map watchEvent = (Map)RawWatchConnectionManager.this.objectMapper.readValue(text, HashMap.class);
                    String watchEventType = watchEvent.get("type").toString();
                    String watchObjectAsString = RawWatchConnectionManager.this.objectMapper.writeValueAsString(watchEvent.get("object"));
                    RawWatchConnectionManager.this.watcher.eventReceived(Watcher.Action.valueOf(watchEventType), watchObjectAsString);
                }
                catch (IOException exception) {
                    logger.error("Failed to deserialize watch response: " + exception.getMessage());
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                this.onMessage(webSocket, bytes.utf8());
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                logger.info("Socket closing: " + reason);
                webSocket.close(code, reason);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                logger.debug("WebSocket close received. code: {}, reason: {}", (Object)code, (Object)reason);
                if (RawWatchConnectionManager.this.forceClosed.get()) {
                    logger.debug("Ignoring onClose for already closed/closing websocket");
                    return;
                }
                if (RawWatchConnectionManager.this.cannotReconnect()) {
                    RawWatchConnectionManager.this.closeEvent(new WatcherException("Connection unexpectedly closed"));
                    return;
                }
                RawWatchConnectionManager.this.scheduleReconnect();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                if (RawWatchConnectionManager.this.forceClosed.get()) {
                    logger.debug("Ignoring onFailure for already closed/closing websocket", t);
                    if (response != null && response.body() != null) {
                        response.body().close();
                    }
                    return;
                }
                if (response != null && response.code() == 200) {
                    RawWatchConnectionManager.this.queue.clear();
                    RawWatchConnectionManager.this.queue.offer(new KubernetesClientException("Received 200 on websocket", response.code(), null));
                    response.body().close();
                    return;
                }
                if (response != null) {
                    Status status = OperationSupport.createStatus(response);
                    if (response.body() != null) {
                        response.body().close();
                    }
                    logger.warn("Exec Failure: HTTP {}, Status: {} - {}", new Object[]{response.code(), status.getCode(), status.getMessage(), t});
                    if (!RawWatchConnectionManager.this.started.get()) {
                        RawWatchConnectionManager.this.queue.clear();
                        RawWatchConnectionManager.this.queue.offer(new KubernetesClientException(status));
                    }
                } else {
                    logger.warn("Exec Failure", t);
                    if (!RawWatchConnectionManager.this.started.get()) {
                        RawWatchConnectionManager.this.queue.clear();
                        RawWatchConnectionManager.this.queue.offer(new KubernetesClientException("Failed to start websocket", t));
                    }
                }
                if (RawWatchConnectionManager.this.cannotReconnect()) {
                    RawWatchConnectionManager.this.closeEvent(new WatcherException("Connection failure", t));
                    return;
                }
                RawWatchConnectionManager.this.scheduleReconnect();
            }
        });
    }

    private void scheduleReconnect() {
        logger.debug("Submitting reconnect task to the executor");
        this.submit(new NamedRunnable("scheduleReconnect"){

            @Override
            public void execute() {
                if (!RawWatchConnectionManager.this.reconnectPending.compareAndSet(false, true)) {
                    logger.debug("Reconnect already scheduled");
                    return;
                }
                RawWatchConnectionManager.this.webSocketRef.set(null);
                try {
                    logger.debug("Scheduling reconnect task");
                    RawWatchConnectionManager.this.schedule(new NamedRunnable("reconnectAttempt"){

                        @Override
                        public void execute() {
                            try {
                                RawWatchConnectionManager.this.runWatch();
                                RawWatchConnectionManager.this.reconnectPending.set(false);
                            }
                            catch (Exception e) {
                                logger.error("Exception in reconnect", (Throwable)e);
                                RawWatchConnectionManager.this.webSocketRef.set(null);
                                RawWatchConnectionManager.this.closeEvent(new WatcherException("Unhandled exception in reconnect attempt", e));
                                RawWatchConnectionManager.this.close();
                            }
                        }
                    }, RawWatchConnectionManager.this.nextReconnectInterval(), TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    RawWatchConnectionManager.this.reconnectPending.set(false);
                }
            }
        });
    }

    public void waitUntilReady() {
        Utils.waitUntilReady(this.queue, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        logger.debug("Force closing the watch {}", (Object)this);
        this.closeEvent();
        RawWatchConnectionManager.closeWebSocket(this.webSocketRef.getAndSet(null));
        this.closeExecutorService();
    }
}

