/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.readiness;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReadinessTest {
    @Test
    public void testStatefulSetReadinessNoSpecNoStatus() {
        StatefulSet statefulSet = new StatefulSet();
        Assertions.assertFalse((boolean)Readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    public void testStatefulSetReadinessNoSpec() {
        StatefulSetStatus status = new StatefulSetStatus();
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setStatus(status);
        Assertions.assertFalse((boolean)Readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
        status.setReadyReplicas(Integer.valueOf(1));
        Assertions.assertFalse((boolean)Readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    public void testStatefulSetReadinessNoStatus() {
        StatefulSetSpec spec = new StatefulSetSpec();
        spec.setReplicas(Integer.valueOf(1));
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setSpec(spec);
        Assertions.assertFalse((boolean)Readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    public void testStatefulSetReadinessNotEnoughReadyReplicas() {
        StatefulSetStatus status = new StatefulSetStatus();
        status.setReadyReplicas(Integer.valueOf(1));
        status.setReplicas(Integer.valueOf(2));
        StatefulSetSpec spec = new StatefulSetSpec();
        spec.setReplicas(Integer.valueOf(2));
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setStatus(status);
        statefulSet.setSpec(spec);
        Assertions.assertFalse((boolean)Readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertFalse((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }

    @Test
    public void testStatefulSetReadiness() {
        StatefulSetStatus status = new StatefulSetStatus();
        status.setReadyReplicas(Integer.valueOf(2));
        status.setReplicas(Integer.valueOf(2));
        StatefulSetSpec spec = new StatefulSetSpec();
        spec.setReplicas(Integer.valueOf(2));
        StatefulSet statefulSet = new StatefulSet();
        statefulSet.setStatus(status);
        statefulSet.setSpec(spec);
        Assertions.assertTrue((boolean)Readiness.isReady((HasMetadata)statefulSet));
        Assertions.assertTrue((boolean)Readiness.isStatefulSetReady((StatefulSet)statefulSet));
    }
}

