/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.WaitForConditionWatcher;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WaitForConditionWatcherTest {
    private final ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("test")).withNamespace("test")).endMetadata()).addToData("foo", "bar")).build();

    WaitForConditionWatcherTest() {
    }

    @Test
    void itCompletesOnMatchAdded() throws Exception {
        TrackingPredicate condition = this.condition(ss -> true);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.ADDED, (HasMetadata)this.configMap);
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        Assertions.assertEquals(watcher.getFuture().get(), (Object)this.configMap);
        condition.isCalledWith(this.configMap);
    }

    @Test
    void itCompletesOnMatchModified() throws Exception {
        TrackingPredicate condition = this.condition(ss -> true);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.MODIFIED, (HasMetadata)this.configMap);
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        Assertions.assertEquals(watcher.getFuture().get(), (Object)this.configMap);
        condition.isCalledWith(this.configMap);
    }

    @Test
    void itCompletesOnMatchDeleted() throws Exception {
        TrackingPredicate condition = this.condition(Objects::isNull);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.DELETED, (HasMetadata)this.configMap);
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        Assertions.assertNull(watcher.getFuture().get());
        condition.isCalledWith(null);
    }

    @Test
    void itDoesNotCompleteOnNoMatchAdded() {
        TrackingPredicate condition = this.condition(ss -> false);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.ADDED, (HasMetadata)this.configMap);
        Assertions.assertFalse((boolean)watcher.getFuture().isDone());
        condition.isCalledWith(this.configMap);
    }

    @Test
    void itDoesNotCompleteOnNoMatchModified() {
        TrackingPredicate condition = this.condition(ss -> false);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.MODIFIED, (HasMetadata)this.configMap);
        Assertions.assertFalse((boolean)watcher.getFuture().isDone());
        condition.isCalledWith(this.configMap);
    }

    @Test
    void itDoesNotCompleteOnNoMatchDeleted() {
        TrackingPredicate condition = this.condition(Objects::nonNull);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.DELETED, (HasMetadata)this.configMap);
        Assertions.assertFalse((boolean)watcher.getFuture().isDone());
        condition.isCalledWith(null);
    }

    @Test
    void itCompletesExceptionallyOnError() throws Exception {
        TrackingPredicate condition = this.condition(ss -> true);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.eventReceived(Watcher.Action.ERROR, (HasMetadata)this.configMap);
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        try {
            watcher.getFuture().get();
            Assertions.fail((String)"should have thrown exception");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(WatcherException.class, e.getCause().getClass());
            Assertions.assertEquals((Object)"Action.ERROR received", (Object)e.getCause().getMessage());
        }
        Assertions.assertFalse((boolean)condition.isCalled());
    }

    @Test
    void itCompletesExceptionallyWithRetryOnCloseNonGone() throws Exception {
        TrackingPredicate condition = this.condition(ss -> true);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.onClose(new WatcherException("Watcher closed", (Throwable)new KubernetesClientException("test", 500, null)));
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        try {
            watcher.getFuture().get();
            Assertions.fail((String)"should have thrown exception");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(WatcherException.class, e.getCause().getClass());
            Assertions.assertEquals((Object)"Watcher closed", (Object)e.getCause().getMessage());
            Assertions.assertTrue((boolean)((WatcherException)e.getCause()).isShouldRetry());
        }
        Assertions.assertFalse((boolean)condition.isCalled());
    }

    @Test
    void itCompletesExceptionallyWithNoRetryOnCloseGone() throws Exception {
        TrackingPredicate condition = this.condition(ss -> true);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.onClose(new WatcherException("Watcher closed", (Throwable)new KubernetesClientException("test", 410, null)));
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        try {
            watcher.getFuture().get();
            Assertions.fail((String)"should have thrown exception");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(WatcherException.class, e.getCause().getClass());
            Assertions.assertEquals((Object)"Watcher closed", (Object)e.getCause().getMessage());
            Assertions.assertFalse((boolean)((WatcherException)e.getCause()).isShouldRetry());
        }
        Assertions.assertFalse((boolean)condition.isCalled());
    }

    @Test
    void itCompletesExceptionallyWithRetryOnGracefulClose() throws Exception {
        TrackingPredicate condition = this.condition(ss -> true);
        WaitForConditionWatcher watcher = new WaitForConditionWatcher((Predicate)condition);
        watcher.onClose();
        Assertions.assertTrue((boolean)watcher.getFuture().isDone());
        try {
            watcher.getFuture().get();
            Assertions.fail((String)"should have thrown exception");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(WatcherException.class, e.getCause().getClass());
            Assertions.assertEquals((Object)"Watcher closed", (Object)e.getCause().getMessage());
            Assertions.assertTrue((boolean)((WatcherException)e.getCause()).isShouldRetry());
        }
        Assertions.assertFalse((boolean)condition.isCalled());
    }

    private TrackingPredicate condition(Predicate<ConfigMap> condition) {
        return new TrackingPredicate(condition);
    }

    private ConfigMap configMap() {
        return ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("test")).withNamespace("test")).endMetadata()).addToData("foo", "bar")).build();
    }

    private static class TrackingPredicate
    implements Predicate<ConfigMap> {
        private final Predicate<ConfigMap> delegate;
        private boolean called;
        private ConfigMap calledWith;

        public TrackingPredicate(Predicate<ConfigMap> delegate) {
            this.delegate = delegate;
            this.called = false;
            this.calledWith = null;
        }

        @Override
        public boolean test(ConfigMap configMap) {
            this.called = true;
            this.calledWith = configMap;
            return this.delegate.test(configMap);
        }

        public boolean isCalled() {
            return this.called;
        }

        public boolean isCalledWith(ConfigMap configMap) {
            return this.called && Objects.equals(configMap, this.calledWith);
        }
    }
}

